<?php get_header(); ?>

<div class="product_cat-publications-template custom-tax-archive">
    <section class="p-header p-artist-header product_cat-publications-template__product-publications-header">
        <div class="p-header__title p-header-title">
            <div class="p-header-title__contain contain">
                <?php if ( function_exists('yoast_breadcrumb') ) {
                    yoast_breadcrumb( '<div class="p-header-title__breadcrumbs ff-title">', '</div>' );
                } ?>

                <h1 class="ff-title">Publications</h1>
            </div>
        </div>
        <?php get_template_part('templates/sections/publications-navigation'); ?>
    </section>
    <section class="product_cat-publications-template__product-publications-output">
        <div class="contain">

            <?= get_template_part('templates/sections/product-filter'); ?>

            <div class="row row-eq-height">
                <?php if ( have_posts() ) {
                    $defaultImage = \Blue2\Scruffy\Site::getDefaultImage();
                    while ( have_posts() ) {
                        the_post();
                        global $product;
                        $associatedArtists = get_field('associated_artists');
                        $title = get_the_title();
                        $imageData = \Blue2\Scruffy\Site::getPostImage(get_the_id(), 'flexible-image-block-4');
                        ?>
                        <div class="col-sm-6 col-md-4 col-lg-3 publication-product-item-col">
                            <div class="publication-product-item">
                                <div class="publication-product-item__image-wrapper image-wrapper <?= $imageData['class'] ?>">
                                    <a href="<?php the_permalink(); ?>">
                                        <?php if(!$product->is_in_stock()) { ?>
                                            <span class="out-of-stock ff-title">Out of Stock</span>
                                        <?php } ?>
                                        <?= $imageData['item']; ?>
                                    </a>
                                </div>
                                <div class="publication-product-item__info-wrapper content-wrapper">
                                    <?php if($associatedArtists) { ?>
                                        <ul class="associated-artists">
                                            <?php foreach($associatedArtists as $artist) { ?>
                                                <li class="ff-title"><a href="<?= get_the_permalink($artist); ?>"><?= get_the_title($artist); ?></a></li>
                                            <?php } ?>
                                        </ul>
                                    <?php } ?>
                                    <h2><?= $title; ?></h2>
                                    <?php if($product->get_price()) { ?><div class="price"><?= get_woocommerce_currency_symbol() . $product->get_price(); ?></div><?php } ?>
                                </div>
                            </div>
                        </div>

                    <?php } wp_reset_postdata();
                } else {
                    $noResultsTitle = get_field('no_results_title_publications', 'option');
                    $noResultsDescription = get_field('no_results_description_publications', 'option');
                    ?>
                    <div class="col-12">
                        <div class="no-results">
                            <?php if($noResultsTitle) { ?><h3 class="title"><?= $noResultsTitle; ?></h3><?php } ?>
                            <?php if($noResultsDescription) { ?><div class="description"><?= $noResultsDescription; ?></div><?php } ?>
                        </div>
                    </div>
                <?php } ?>
            </div>
            <div class="custom-pagination">
                <?php the_posts_pagination([
                    'mid_size' => 1,
                    'prev_text' => __('<', 'textdomain'),
                    'next_text' => __('>', 'textdomain'),
                    'before_page_number' => '<span class="meta-nav screen-reader-text">' . __('', '') . ' </span>',
                ]); ?>
            </div>
        </div>
    </section>
</div>

<?php get_footer(); ?>
