<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;
?>


<?php
/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked woocommerce_output_all_notices - 10
 */
do_action( 'woocommerce_before_single_product' );

if ( post_password_required() ) {
    echo get_the_password_form(); // WPCS: XSS ok.
    return;
}

$associatedArtists = get_field('associated_artists');
$extraTitleInfo = get_field('extra_title_info');
$additionalInformation = get_field('additional_information');

$length = $product->get_length();
$width = $product->get_width();
$height = $product->get_height();
$diameter = get_post_meta( $product->get_id(), '_diameter', true );

$sizeString = "";

if($length) {
    $sizeString .= "L:" . $length . 'cm ';
}
if($height){
    $sizeString .= "H:" . $height . 'cm ';
}
if($width){
    $sizeString .= "W:" . $width . 'cm ';
}
if($diameter){
    $sizeString .= "D:" . $diameter . 'cm ';
}

?>
<div id="product-<?php the_ID(); ?>" <?php wc_product_class( '', $product ); ?>>
    <div class="contain">

        <div class="product-main">
            <div class="row">
                <div class="col-lg-6"></div>
                <div class="col-lg-6">

                    <div class="product-information">
                        <?php if($associatedArtists) { ?>
                            <ul class="associated-artists">
                                <?php foreach($associatedArtists as $artist) { ?>
                                    <li class="ff-title"><a href="<?= get_the_permalink($artist); ?>"><?= get_the_title($artist); ?></a></li>
                                <?php } ?>
                            </ul>
                        <?php } ?>
                        <h1><?php the_title(); ?><?php if($extraTitleInfo) { echo ', ' . $extraTitleInfo; } ?></h1>
                        <?php if($additionalInformation) { ?><div class="additional-information"><?= $additionalInformation; ?></div><?php } ?>
                        <?php if($sizeString) { ?><div class="dimensions"><?= $sizeString; ?></div><?php } ?>
                        <div class="description"><?php the_content(); ?></div>

                        <div class="pricing">

                        </div>

                        <div class="ctas">

                        </div>
                    </div>


                </div>
            </div>
        </div>

        <div class="custom-related-products">
            <?php
            /**
             * Hook: woocommerce_after_single_product_summary.
             *
             * @hooked woocommerce_output_product_data_tabs - 10
             * @hooked woocommerce_upsell_display - 15
             * @hooked woocommerce_output_related_products - 20
             */
            do_action( 'woocommerce_after_single_product_summary' );
            ?>
        </div>
    </div>
</div>

<?php do_action( 'woocommerce_after_single_product' ); ?>
