<?php get_header();
$queryObject = get_queried_object();
$craftProductCategory = get_term_by('slug', 'craft-design', 'product_cat');
?>

<div class="product_cat-craft-template custom-tax-archive">
    <section class="p-header p-artist-header product_cat-craft-template__product-craft-header">
        <div class="p-header__title p-header-title">
            <div class="p-header-title__contain contain">
                <?php if ( function_exists('yoast_breadcrumb') ) {
                    yoast_breadcrumb( '<div class="p-header-title__breadcrumbs ff-title">', '</div>' );
                } ?>
                <?php if($queryObject->parent == $craftProductCategory->term_id) { ?>
                    <h2 class="craft-title">Craft <span>&</span> Design</h2>
                    <h1 class="craft-taxonomy-title"><?php single_term_title(); ?></h1>
                <?php } else { ?>
                    <h1 class="craft-title">Craft <span>&</span> Design</h1>
                <?php } ?>
            </div>
        </div>
        <?php get_template_part('templates/sections/craft-design-navigation'); ?>
    </section>
    <section class="product_cat-craft-template__product-craft-output">
        <div class="contain">
            <div class="row row-eq-height">
                <?php if ( have_posts() ) {

                    get_template_part('templates/sections/product-filter');

                    $defaultImage = \Blue2\Scruffy\Site::getDefaultImage();
                    while ( have_posts() ) {
                        the_post();
                        $associatedArtists = get_field('associated_artists');
                        $title = get_the_title();
                        //todo - check with chris about custom parameters for dimensions
                        $dimensions = "H:6.5cm W:5.5cm D:0.5cm";
                        $imageData = \Blue2\Scruffy\Site::getPostImage(get_the_id(), 'craft-item');
                        ?>
                        <div class="col-sm-6 col-lg-4 craft-product-item-col">
                            <div class="craft-product-item">
                                <div class="craft-product-item__image-wrapper image-wrapper <?= $imageData['class'] ?>">
                                    <a href="<?php the_permalink(); ?>">
                                        <?= $imageData['item']; ?>
                                    </a>
                                </div>
                                <div class="craft-product-item__info-wrapper content-wrapper">
                                    <?php if($associatedArtists) { ?>
                                        <ul class="associated-artists">
                                            <?php foreach($associatedArtists as $artist) { ?>
                                                <li class="ff-title"><a href="<?= get_the_permalink($artist); ?>"><?= get_the_title($artist); ?></a></li>
                                            <?php } ?>
                                        </ul>
                                    <?php } ?>
                                    <h2><?= $title; ?></h2>
                                    <?php if($dimensions) { ?><div class="dimensions"><?= $dimensions; ?></div><?php } ?>
                                </div>
                                <a href="<?php the_permalink(); ?>" class="cta ff-title">View Details <span class="icon-arrow far fa-long-arrow-right"></span></a>
                            </div>
                        </div>

                    <?php } wp_reset_postdata();
                } else {
                    $noResultsTitle = get_field('no_results_title_craft', 'option');
                    $noResultsDescription = get_field('no_results_description_craft', 'option');
                    ?>
                    <div class="col-12">
                        <div class="no-results">
                            <?php if($noResultsTitle) { ?><h3 class="title"><?= $noResultsTitle; ?></h3><?php } ?>
                            <?php if($noResultsDescription) { ?><div class="description"><?= $noResultsDescription; ?></div><?php } ?>
                        </div>
                    </div>
                <?php } ?>
            </div>
            <div class="custom-pagination">
                <?php the_posts_pagination([
                    'mid_size' => 1,
                    'prev_text' => __('<', 'textdomain'),
                    'next_text' => __('>', 'textdomain'),
                    'before_page_number' => '<span class="meta-nav screen-reader-text">' . __('', '') . ' </span>',
                ]); ?>
            </div>
        </div>
    </section>
</div>

<?php get_footer(); ?>
