<?php
$artists = get_posts(['post_type' => 'artist', 'numberposts' => -1, 'orderby' => 'title', 'order' => 'ASC']);
$mediumList = get_terms('medium', ['hide_empty' => false]);
$subjectList = get_terms('subject', ['hide_empty' => false]);
?>

<div class="col-12">
    <div class="product-filter">
        <div class="product-filter__filter-buttons ff-title">
            <div class="filter-group">
                <button class="filter-button" id="sort-by" aria-label="Open filter options" aria-expanded="false">Sort by <span class="far fa-plus"></span></button>
                <div class="filter-options">
                    <div class="inner-filter">

                    </div>
                </div>
            </div>
            <div class="filter-group">
                <button class="filter-button" id="filter-by" aria-label="Open filter options" aria-expanded="false">Filter by type <span class="far fa-plus"></span></button>
                <div class="filter-options">
                    <div class="inner-filter">
                        <form method="post">
                            <fieldset>
                                <div class="fieldset-title" role="button" aria-label="Open Artist Filters" data-title="Artist">
                                    <span>Artist</span>
                                    <span class="far fa-plus filter-dropdown-toggle"></span>
                                </div>
                                <div class="checkbox-wrapper">
                                    <?php if($artists) {
                                        foreach($artists as $artist) {

                                            ?>
                                            <div class="checkbox-option">
                                                <input type="checkbox" id="<?= $artist->post_name; ?>" value="<?= $artist->ID; ?>" name="filter-artist[]" <?= isset($_POST) && array_key_exists('filter-artist', $_POST) && in_array($artist->ID, $_POST['filter-artist']) ? "checked" : ""; ?>>
                                                <label for="<?= $artist->post_name; ?>"><?= $artist->post_title; ?></label>
                                            </div>
                                        <?php } wp_reset_postdata();
                                    } ?>
                                </div>
                            </fieldset>
                            <fieldset>
                                <div class="fieldset-title" role="button" aria-label="Open Medium Filters" data-title="Medium">
                                    <span>Medium</span>
                                    <span class="far fa-plus filter-dropdown-toggle"></span>
                                </div>
                                <div class="checkbox-wrapper">
                                    <?php if($mediumList) {
                                        foreach($mediumList as $medium) { ?>
                                            <div class="checkbox-option">
                                                <input type="checkbox" id="<?= $medium->slug; ?>" name="filter-medium[]" <?= isset($_POST) && array_key_exists('filter-medium', $_POST) && in_array($medium->slug, $_POST['filter-medium']) ? "checked" : ""; ?> value="<?= $medium->slug; ?>">
                                                <label for="<?= $medium->slug; ?>"><?= $medium->name; ?></label>
                                            </div>
                                        <?php }
                                    } ?>
                                </div>
                            </fieldset>
                            <fieldset>
                                <div class="fieldset-title" role="button" aria-label="Open Subject Filters" data-title="Subject">
                                    <span>Subject</span>
                                    <span class="far fa-plus filter-dropdown-toggle"></span>
                                </div>
                                <div class="checkbox-wrapper">
                                    <?php if($subjectList) {
                                        foreach($subjectList as $subject) { ?>
                                            <div class="checkbox-option">
                                                <input type="checkbox" id="<?= $subject->slug; ?>" name="filter-subject[]" <?= isset($_POST) && array_key_exists('filter-subject', $_POST) && in_array($subject->slug, $_POST['filter-subject']) ? "checked" : ""; ?> value="<?= $subject->slug; ?>">
                                                <label for="<?= $subject->slug; ?>"><?= $subject->name; ?></label>
                                            </div>
                                        <?php }
                                    } ?>
                                </div>
                            </fieldset>

                            <fieldset>
                                <div class="range-wrapper">
                                    <label for="price-range">Price</label>
                                    <input name="price-range" type="range" min="1" max="50000" value="<?= isset($_POST) && array_key_exists('price-range', $_POST) ? $_POST['price-range'] : 50000; ?>" class="slider" id="price-range">
                                    <div class="range-values">
                                        <div class="value">£<span id="lowest-value">0</span></div>
                                        <div class="value">£<span id="variable-value">50,000</span></div>
                                    </div>
                                </div>
                            </fieldset>

                            <div class="form-buttons">
                                <button type="submit" class="clear">Clear</button>
                                <button type="submit" class="gold-button">Search</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
