<?php
$imageBlocks = get_sub_field('images');
if($imageBlocks) {
    $imagesPerRow = get_sub_field('images_per_row');
    switch($imagesPerRow){
        case 3:
            $grid = 'grid-3-row';
            $imageSize = 'flexible-image-block-3';
            break;
        case 4:
            $grid = 'grid-4-row';
            $imageSize = 'flexible-image-block-4';
            break;
        case 6:
            $grid = 'grid-6-row';
            $imageSize = 'flexible-image-block-6';
    } ?>
    <section class="custom-flexible-section image-blocks">
        <div class="image-blocks__contain contain">
            <div class="image-grid <?= $grid; ?>">
                <?php foreach($imageBlocks as $block) {
                    $imageID = $block['image'];
                    $imageAlt = get_post_meta($imageID, '_wp_attachment_image_alt', TRUE);
                    $imageDetails = wp_get_attachment_image_src($imageID, $imageSize);
                    $image = '<img src="' . $imageDetails[0] . '" alt="' . $imageAlt . '" loading="lazy"/>';
                    ?>

                    <div class="image-col d-flex <?= 'align-items-' . $block['vertical_alignment'] . ' ' . 'justify-content-' . $block['horizontal_alignment']; ?>">
                        <?php if($block['url']) { ?><a href="<?= $block['url']['url']; ?>" target="<?= $block['url']['target']; ?>"><?php } ?>
                            <?= $image; ?>
                        <?php if($block['url']) { ?></a><?php } ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </section>
<?php } ?>
