<?php

$artists = get_posts(['post_type' => 'artist', 'numberposts' => -1, 'orderby' => 'title', 'order' => 'ASC']);
$mediumList = get_terms('medium', ['hide_empty' => false]);
$subjectList = get_terms('subject', ['hide_empty' => false]);

?>



<div class="product-filter">
    <div class="product-filter__filter-buttons ff-title">
        <div class="btn-group">
            <button class="filter-button" id="sort-by" aria-label="Sort the products" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Sort by <span class="far fa-plus"></span></button>
            <div class="dropdown-menu">

            </div>
        </div>
        <div class="btn-group">
            <button class="filter-button" id="filter-by" aria-label="Filter the products" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Filter by type <span class="far fa-plus"></span></button>
            <div class="dropdown-menu">
                <form method="get">

                    <fieldset>
                        <div class="fieldse-title">Artists</div>
                        <div class="checkbox-wrapper">
                            <?php if($artists) {
                                foreach($artists as $artist) { ?>
                                    <div class="checkbox-option">
                                        <input type="checkbox" id="<?= $artist->post_name; ?>" name="filter-artist[]" <?= isset($_GET['filter-artist']) && $_GET['filter-artist'] == $artist->post_name ? 'checked' : ""; ?> value="<?= $artist->post_name; ?>">
                                        <label for="<?= $artist->post_name; ?>"><?= $artist->post_title; ?></label>
                                    </div>
                                <?php }
                            } ?>
                        </div>
                    </fieldset>

                    <button type="submit" class="gold-button">Search</button>
                </form>
            </div>
        </div>
    </div>

</div>
