<?php

$defaultImage = \Blue2\Scruffy\Site::getDefaultImage();

$date = get_field('date_time');
$subtitle = get_field('subtitle');
$dateOutput = date("l jS F, h:ia", strtotime($date));

if(get_post_thumbnail_id()){
    $imgID = get_post_thumbnail_id();
    $imageAlt = get_post_meta($imgID, '_wp_attachment_image_alt', TRUE);
    $imageDetails = wp_get_attachment_image_src($imgID, 'small-event-image');
    $image = '<img src=" ' . $imageDetails[0] . '" alt="'. $imageAlt .'" loading="lazy">';
    $imageClass = 'featured-image';
} else {
    $image = $defaultImage;
    $imageClass = 'default-image';
}

?>

<div class="col-md-6 col-lg-4 event-archive-item standard">
    <a href="<?= get_permalink(); ?>">
        <div class="row">
            <div class="col-xl-6">
                <div class="image-wrapper <?= $imageClass; ?>">
                    <?= $image; ?>
                </div>
            </div>
            <div class="col-xl-6 content-col">
                <div class="date"><?= date("l jS F, h:ia",  strtotime(get_field('date_time'))); ?></div>
                <h3><?= get_the_title(); ?></h3>
                <?php if(get_field('subtitle')) { ?><div class="subtitle"><?php the_field('subtitle'); ?></div><?php } ?>
            </div>
        </div>
    </a>
</div>
