<?php

$defaultImage = \Blue2\Scruffy\Site::getDefaultImage();

$date = get_field('date_time');
$subtitle = get_field('subtitle');
$dateOutput = date("l jS F, h:ia", strtotime($date));

if(get_post_thumbnail_id()){
    $imgID = get_post_thumbnail_id();
    $imageAlt = get_post_meta($imgID, '_wp_attachment_image_alt', TRUE);
    $imageDetails = wp_get_attachment_image_src($imgID, 'whats-on-archive-large');
    $image = '<img src=" ' . $imageDetails[0] . '" alt="'. $imageAlt .'" loading="lazy">';
    $imageClass = 'featured-image';
} else {
    $image = $defaultImage;
    $imageClass = 'default-image';
}

?>


<div class="col-md-6 col-lg-6 event-archive-item featured">
    <div class="image-wrapper <?= $imageClass; ?>">
        <a href="<?= get_the_permalink(); ?>">
            <?= $image;  ?>
        </a>
    </div>
    <div class="content-wrap">
        <div class="date"><?= $dateOutput; ?></div>
        <h2><?php the_title(); ?></h2>
        <?php if($subtitle) { ?><div class="subtitle"><?= $subtitle; ?></div><?php } ?>
    </div>
</div>
