<?php

namespace Blue2\Scruffy\Controllers;

class ProductController
{
    public function __construct()
    {
        $this->registerActions();
        $this->registerFilters();
    }

    private function registerActions()
    {
        add_action('pre_get_posts', [$this, 'productArchiveAdjustments']);
    }

    private function registerFilters()
    {
        add_filter('template_include', [$this, 'taxonomyTemplateFallbackAdjustments'], 11);
    }

    public static function getAssociatedArtists($id = null){

        $productID = $id ?: get_the_id();
        $artists = get_field('associated_artists', $productID);

        $artistNames = [];
        if($artists) {
            foreach ($artists as $artist) {
                array_push($artistNames, [ 'id' => $artist->ID, 'name' => $artist->post_title]);
            }
        }

        return $artistNames;
    }

    public function productArchiveAdjustments( $query ) {
        if ( !is_admin() && $query->is_main_query() && is_tax('product_cat')) {
            $queryObject = $query->queried_object;
            $craftProductCategory = get_term_by('slug', 'craft-design', 'product_cat');
            $publicationProductCategory = get_term_by('slug', 'publications', 'product_cat');
            $artworksProductCategory = get_term_by('slug', 'artworks', 'product_cat');

            if($queryObject->parent == $craftProductCategory->term_id || $queryObject->term_id == $craftProductCategory->term_id) {
                $postsPerPage = get_field('craft_products_per_page_archive', 'option') ?: 12;
                $query->set('posts_per_page', $postsPerPage);
            } elseif($queryObject->parent == $publicationProductCategory->term_id || $queryObject->term_id == $publicationProductCategory->term_id) {
                $postsPerPage = get_field('publication_products_per_page_archive', 'option') ?: 12;
                $query->set('posts_per_page', $postsPerPage);
            } elseif($queryObject->parent == $artworksProductCategory->term_id || $queryObject->term_id == $artworksProductCategory->term_id) {
                $postsPerPage = get_field('artwork_products_per_page_archive', 'option') ?: 12;
                $query->set('posts_per_page', $postsPerPage);
            }
        }
    }

    function taxonomyTemplateFallbackAdjustments( $template ) {
        if ( is_tax('product_cat') ) {
            $craftDesign = get_term_by('slug', 'craft-design', 'product_cat');
            $publications = get_term_by('slug', 'publications', 'product_cat');
            $artworks = get_term_by('slug', 'artworks', 'product_cat');

            if (term_is_ancestor_of($craftDesign, get_queried_object(), 'product_cat')) {
                return get_template_directory() . '/taxonomy-product_cat-craft-design.php';
            } elseif(term_is_ancestor_of($publications, get_queried_object(), 'product_cat')){
                return get_template_directory() . '/taxonomy-product_cat-publications.php';
            }
        }
        return $template;
    }

}
