<!-- todo - add search functionality -->
<!-- todo - sort overlap of button on focus -->
<!-- todo - add hover effect on close -->

<?php
$artists = get_posts(['post_type' => 'artist', 'numberposts' => -1, 'orderby' => 'title', 'order' => 'ASC']);
$mediumList = get_terms('medium', ['hide_empty' => false]);
$subjectList = get_terms('subject', ['hide_empty' => false]);
$curatedList = get_terms('curated', ['hide_empty' => false]);
?>

<div class="search-block" aria-expanded="false">
    <div class="search-block__close"><div class="close-wrapper ff-title">Close<span class="l-icons__search-close far fa-times" aria-label="Close Search Bar" role="button"></span></div></div>
    <div class="search-block__contain contain">
        <form method="get" class="form-grid" id="searchform"  action="<?= esc_url( home_url( '/' ) ); ?>" role="search">
            <div class="grid-item">
                <label for="search-curated" class="ff-title">Curated for you:</label>
                <div class="select-wrapper">
                    <select name="search-curated" id="search-curated">
                        <option value="" selected disabled hidden>I am...</option>
                        <?php if($curatedList) {
                            foreach($curatedList as $curated) { ?>
                                <option value="<?= $curated->slug; ?>"><?= $curated->name; ?></option>
                            <?php }
                        } ?>
                    </select>
                </div>
            </div>
            <div class="grid-item">
                <label for="search-keyword" class="ff-title">Search by keyword:</label>
                <div class="text-input-wrapper">
                    <input type="text" name="s" id="search-keyword" placeholder="Search for...">
                </div>
            </div>

            <div class="grid-item">
                <label for="search-price" class="ff-title">Price</label>
                <div class="select-wrapper">
                    <select name="search-price" id="search-price">
                        <option value="all">All</option>
                    </select>
                </div>
            </div>

            <div class="grid-item">
                <label for="search-artist" class="ff-title">Artist</label>
                <div class="select-wrapper">
                    <select name="search-artist" id="search-artist">
                        <option value="all">All</option>
                        <?php if($artists) {
                            foreach($artists as $artist) { ?>
                                <option value="<?= $artist->post_name; ?>"><?= $artist->post_title; ?></option>
                            <?php }
                        } ?>
                    </select>
                </div>
            </div>
            <div class="grid-item">
                <label for="search-medium" class="ff-title">Medium</label>
                <div class="select-wrapper">
                    <select name="search-medium" id="search-medium">
                        <option value="all">All</option>
                        <?php if($mediumList) {
                            foreach($mediumList as $medium) { ?>
                                <option value="<?= $medium->slug; ?>"><?= $medium->name; ?></option>
                            <?php }
                        } ?>
                    </select>
                </div>
            </div>
            <div class="grid-item">
                <label for="search-subject" class="ff-title">Subject</label>
                <div class="select-wrapper">
                    <select name="search-subject" id="search-subject">
                        <option value="all">All</option>
                        <?php if($subjectList) {
                            foreach($subjectList as $subject) { ?>
                                <option value="<?= $subject->slug; ?>"><?= $subject->name; ?></option>
                            <?php }
                        } ?>
                    </select>
                </div>
            </div>
            <div class="grid-item text-center">
                <button type="submit" class="gold-button">Search</button>
            </div>
        </form>
    </div>
</div>
