<?php
namespace Blue2\Scruffy;

use Blue2\Scruffy\Controllers\ArtistController;
use Blue2\Scruffy\Controllers\EventController;
use Blue2\Scruffy\Controllers\WhatsOnController;
use Blue2\Scruffy\Controllers\NewsController;

class Site extends \Blue2\Common\Site
{
    public function __construct()
    {
        parent::__construct();

        add_theme_support('woocommerce');
        add_theme_support('post-thumbnails');
        add_action('after_setup_theme', [$this, 'registerMenus']);
        add_filter('excerpt_more', [$this, 'tidyExcerpt']);

        $this->registerShortCodes();
        $this->registerFilters();
        $this->registerActions();
        $this->setupControllers();
    }

    public function registerMenus()
    {
        register_nav_menus([
            'main_menu' => 'Main Menu',
            'hamburger_menu' => 'Hamburger Menu',
            'footer_menu' => 'Footer Menu'
        ]);
    }

    public function tidyExcerpt()
    {
        return '...';
    }

    private function registerShortCodes()
    {
        // Empty
    }

    private function registerFilters(){
        add_filter('acf/fields/google_map/api', [$this, 'myAcfGoogleMapApi']);
        add_filter('manage_edit-medium_columns', [$this, 'removeTaxonomyCountColumn']);
        add_filter('manage_edit-subject_columns', [$this, 'removeTaxonomyCountColumn']);
        add_filter('manage_edit-curated_columns', [$this, 'removeTaxonomyCountColumn']);
        add_filter('style_loader_tag', [$this, 'styleDeferrer'], 10, 3);
    }

    private function registerActions() {
        add_action('init', [$this, 'registerPostTypes']);
        add_action('init', [$this, 'customImageSizes']);
        add_action('admin_menu', [$this, 'customAdminPages']);
        add_action('init', [$this, 'registerSharedTaxonomies']);
        add_action('navigation_markup_template', [$this, 'removePaginationHeader']);
        add_action('pre_get_posts', [$this, 'getSearchResults']);
        add_action('wp_enqueue_scripts', [$this, 'dequeueStyles'], 100);
        add_action('wp_print_scripts', [$this, 'dequeueScripts'], 100 );
    }

    private function setupControllers(){
        new WhatsOnController();
        new ArtistController();
        new EventController();
        new NewsController();
    }

    public function registerPostTypes()
    {
        Post\Event::registerPostType();
        Post\Artist::registerPostType();
        Post\WhatsOn::registerPostType();
    }

    public function myAcfGoogleMapApi($api)
    {
        $api['key'] = 'AIzaSyDdUGCrXY_C6q_xVXAJUgeRXyNkO4SldDs';
        return $api;
    }

    public function customImageSizes()
    {
        add_image_size('whats-on-archive-large', 760, 570, true);
        add_image_size('whats-on-archive-small', 356, 356, true);
        add_image_size('whats-on-single-full', 1568, 627, false);
        add_image_size('block-slide', 495, 371, true);
        add_image_size('artist-image', 280, 280, true);
        add_image_size('artist-image-large', 355, 355, true);
        add_image_size('featured-event-image', 1029, 772, true);
        add_image_size('small-event-image', 221, 166, true);
        add_image_size('flexible-featured-media', 1029, 1029, true);
        add_image_size('flexible-standard-media', 489, 489, true);
        add_image_size('flexible-split-25', 356, 0, false);
        add_image_size('flexible-split-40', 625, 0, false);
        add_image_size('flexible-split-50', 760, 0, false);
        add_image_size('flexible-split-60', 895, 0, false);
        add_image_size('flexible-split-75', 1164, 0, false);
        add_image_size('flexible-image-block-3', 491, 0, false);
        add_image_size('flexible-image-block-4', 356, 0, false);
        add_image_size('flexible-image-block-6', 221, 0, false);
        add_image_size('post-single', 1568, 0, false);
    }

    public function customAdminPages()
    {
        if (function_exists('acf_add_options_page')) {
            acf_add_options_page([
                'title' => 'What\'s On Settings',
                'parent' => 'edit.php?post_type=whats-on',
                'capability' => 'edit_posts',
            ]);
        }
    }

    public static function getDefaultImage() {
        $path = get_template_directory() . '/dist/images/TSG-main-logo.svg';
        $file = file_get_contents($path);
        // remove xml header
        $file = str_replace(
            '<?xml version="1.0" encoding="UTF-8"?>',
            '',
            $file
        );
        // add class and attributes for accessibility
        return str_replace(
            '<svg',
            '<svg class="l-header__logo" role="img" aria-label="The Scottish Gallery"',
            $file
        );
    }

    public static function getPostImage($id, $size = null){
        $imageSize = $size ?: 'full';
        $defaultImage = self::getDefaultImage();
        $imgID = get_post_thumbnail_id($id);
        if($imgID) {
            $imageAlt = get_post_meta($imgID, '_wp_attachment_image_alt', TRUE);
            $imageDetails = wp_get_attachment_image_src($imgID, $imageSize);
            $image = '<img src="' . $imageDetails[0] . '" alt="' . $imageAlt . '" loading="lazy"/>';
            $imageClass = 'featured-image';
        } else {
            $image = $defaultImage;
            $imageClass = 'default-image';
        }
        return['item' => $image, 'class' => $imageClass];
    }

    function removePaginationHeader($content) {
        $content = preg_replace('#<h2.*?>(.*?)<\/h2>#si', '', $content);
        return $content;
    }

    function registerSharedTaxonomies() {
        register_taxonomy(
            'medium',
            ['product','post', 'artist', 'whats-on', 'event', 'page'],
            [
                'hierarchical' => true,
                'label' => __('Medium', 'medium'),
                'query_var' => 'medium',
                'rewrite' => array( 'slug' => 'medium' )
            ]
        );
        register_taxonomy(
            'subject',
            ['product','post', 'artist', 'whats-on', 'event', 'page'],
            [
                'hierarchical' => true,
                'label' => __('Subject', 'subject'),
                'query_var' => 'subject',
                'rewrite' => array( 'slug' => 'subject' )
            ]
        );
        register_taxonomy(
            'curated',
            ['product','post', 'artist', 'whats-on', 'event', 'page'],
            [
                'hierarchical' => true,
                'label' => __('Curated', 'curated'),
                'query_var' => 'curated',
                'rewrite' => array( 'slug' => 'curated' )
            ]
        );
    }

    function removeTaxonomyCountColumn($columns){
        unset($columns['posts']);
        return $columns;
    }

    public static function getSearchResults($query) {
        if ( !is_admin() && $query->is_main_query() && is_search() ) {
            $query->set( 'posts_per_page', -1 );

        }
    }

    function styleDeferrer($html, $handle, $href) {
        $defer = false;
        $attributes = [];
        $prepend = '';
        $append = '';
        switch ($handle) {
            case 'dashicons':
                $defer = true;
                break;
            case 'admin-bar':
                $defer = true;
                break;
        }
        // if any attributes are set, add them
        if ($attributes) {
            $attribute_html = implode(' ', $attributes);
            $html = str_replace('/>', $attribute_html . ' />', $html);
        }
        /**
         * If the stylesheet is deferred, add fallback in noscript, change media to print,
         * and add onload handler to change media back to all.
         * As print stylesheets are lower priority they are loaded after critical resources.
         *
         * @see https://www.filamentgroup.com/lab/load-css-simpler/
         */
        if ($defer) {
            $fallback_html = '<noscript>' . str_replace('id=\'', 'id=\'noscript-', $html) . '</noscript>';
            $html = str_replace('media=\'all\'', 'media="print" onload="this.media=\'all\'"', $html);
            $html = $html . $fallback_html;
        }
        return $prepend . $html . $append;
    }

    function dequeueStyles(){
        wp_dequeue_style('wp-block-library');
        wp_dequeue_style('wp-block-library-theme');
        wp_dequeue_style('wc-block-style');
    }

    function dequeueScripts(){
        wp_dequeue_script('jquery-migrate');
    }

}
