import { fontawesome, throttle } from './utils';
import Swiper from 'swiper';

const common = () => {
    fontawesome();
    $('.toggle-holder').on('click', function() {
        $('#accordion-list').toggleClass('triggered');
    });

    $('.l-icons__hamburger').on('click', function() {
        const hamburgerNav = $('.l-hamburger__nav');
        hamburgerNav.addClass('triggered');
        hamburgerNav.focus();
        hamburgerNav.attr('aria-expanded', function(i, attr) {
            return attr === 'true' ? 'false' : 'true';
        });
    });

    $('.l-icons__hamburger-close').on('click', function() {
        const hamburgerNav = $('.l-hamburger__nav');
        hamburgerNav.removeClass('triggered');
        hamburgerNav.attr('aria-expanded', function(i, attr) {
            return attr === 'true' ? 'false' : 'true';
        });
    });

    $('.l-icons__search').on('click', function() {
        const searchBlock = $('.search-block');
        $('.l-header').toggleClass('search-triggered');
        searchBlock.toggleClass('triggered');
        searchBlock.attr('aria-expanded', function(i, attr) {
            return attr === 'true' ? 'false' : 'true';
        });
        $(this).attr('aria-label', function(i, attr) {
            return attr === 'Open Search Bar' ? 'Close Search Bar' : 'Open Search Bar';
        });
    });

    $('.search-block__close .close-wrapper').on('click', function() {
        const searchBlock = $('.search-block');
        $('.l-header').removeClass('search-triggered');
        searchBlock.removeClass('triggered');
        searchBlock.attr('aria-expanded', function(i, attr) {
            return attr === 'true' ? 'false' : 'true';
        });
    });


    new Swiper('.slider-output__container', {
        loop: true,
        spaceBetween: 42,
        slidesPerView: 1,
        pagination: {
            el: '.swiper-pagination',
            clickable: true
        },
        navigation: {
            nextEl: '.next-item',
            prevEl: '.prev-item',
        },
    });

    new Swiper('.block-slider-output__container', {
        breakpoints: {
            0: {
                slidesPerView: 1.1,
                spaceBetween: 42
            },
            768: {
                slidesPerView: 2.1,
                spaceBetween: 42
            },
            1200: {
                slidesPerView: 3,
                spaceBetween: 42
            }
        },
        pagination: {
            el: '.swiper-pagination',
            clickable: true
        },
        navigation: {
            nextEl: '.block-next-item',
            prevEl: '.block-prev-item',
        },
    });
};

export default common;
