<?php

$slidesHeading = get_sub_field('slides_heading');
$slides = get_sub_field('slides');

if($slides) { ?>
    <section class="custom-flexible-section block-slider">
        <div class="block-slider__contain contain">

            <div class="block-slides-heading">
                <?php if($slidesHeading) { ?><h2><?= $slidesHeading; ?></h2><?php } ?>
                <div class="arrows">
                    <div class="block-prev-item swiper-nav-button"><div class="inner"><span class="far fa-long-arrow-left"></span></div></div>
                    <div class="block-next-item swiper-nav-button"><div class="inner"><span class="far fa-long-arrow-right"></span></div></div>
                </div>
            </div>

            <div class="block-slider__output block-slider-output">
                <div class="swiper-container block-slider-output__container">
                    <div class="swiper-wrapper block-slider-output__wrapper">
                        <?php foreach($slides as $slide) { ?>
                            <div class="swiper-slide block-slider-output__slide <?= $slide['slide_type']; ?>">
                                <?php if($slide['slide_type'] == 'post-type-selection') {
                                    $id = $slide['post_selector'];
                                    $postType = get_post_type($id);
                                    if($postType == 'whats-on') {
                                        $whatsOnInfo = \Blue2\Scruffy\Controllers\WhatsOnController::getWhatsOnArchiveInfo($id, 'block-slide');
                                        if ($whatsOnInfo['associated_artists']) {
                                            $artistNames = [];
                                            foreach ($whatsOnInfo['associated_artists'] as $artist) {
                                                array_push($artistNames, $artist->post_title);
                                            }
                                        }
                                        $mainTitle = implode(', ', $artistNames) ?: "";
                                        $subtitle = $whatsOnInfo['title'];
                                        $imageClass = $whatsOnInfo['archive_image_class'];
                                        $image = $whatsOnInfo['archive_image'];
                                        $startDate = $whatsOnInfo['start_date'];
                                        $endDate = $whatsOnInfo['end_date'];
                                        $description = $whatsOnInfo['archive_description'];
                                        $link = get_the_permalink($id);
                                    } elseif($postType == 'event') {
                                        $mainTitle = get_the_title($id);
                                        $description = get_the_excerpt($id);
                                        $subtitle = get_field('subtitle', $id) ?: 'Event';
                                        $startDate = date("l jS F, h:ia", strtotime(get_field('date_time', $id)));
                                        $endDate = "";

                                        $imageData = \Blue2\Scruffy\Site::getPostImage($id, 'block-slide');
                                        $imageClass = $imageData['class'];
                                        $image = $imageData['item'];
                                        $link = get_the_permalink($id);


                                    } else {
                                        $postObject = get_post_type_object(get_post_type($id));
                                        $mainTitle = get_the_title($id);
                                        $description = get_the_excerpt($id);
                                        $subtitle = $postType == 'post' ? 'News' : $postObject->labels->singular_name;
                                        $startDate = "";
                                        $endDate = "";
                                        $imageData = \Blue2\Scruffy\Site::getPostImage($id, 'block-slide');
                                        $imageClass = $imageData['class'];
                                        $image = $imageData['item'];
                                        $link = get_the_permalink($id);
                                    }
                                } else {
                                    $mainTitle = $slide['slide_main_title'];
                                    $subtitle = $slide['slide_subtitle'];
                                    $startDate = $slide['slide_start_date'] ? date("d F Y", strtotime($slide['slide_start_date'])) : "";
                                    $endDate = $slide['slide_end_date'] ? date("d F Y", strtotime($slide['slide_end_date'])) : "";
                                    $description = $slide['slide_description'];
                                    $slideImageID = $slide['slide_image'];
                                    $link = $slide['slide_url']['url'];
                                    $defaultImage = \Blue2\Scruffy\Site::getDefaultImage();

                                    if($slideImageID) {
                                        $imageDetails = wp_get_attachment_image_src($slideImageID, 'block-slide');
                                        $imageAlt = get_post_meta($slideImageID, '_wp_attachment_image_alt', TRUE);
                                        $slideImage = '<img src="' . $imageDetails[0] . '" alt="' . $imageAlt . '" loading="lazy"/>';
                                        $imageClass = 'featured-image';
                                    } else {
                                        $image = $defaultImage;
                                        $imageClass = 'default-image';
                                    }
                                }
                                ?>
                                <div class="image-wrapper <?= $imageClass; ?>">
                                    <a href="<?= $link; ?>">
                                        <?= $image; ?>
                                    </a>
                                </div>
                                <div class="content-wrapper">
                                    <div class="title-holder">
                                        <h2 class="ff-title"><?= $mainTitle; ?></h2>
                                        <?php if($subtitle) { ?><h3 class="ff-title"><?= $subtitle; ?></h3><?php } ?>
                                        <?php if($startDate || $endDate) { ?><div class="date"><span class="start-date"><?= $startDate; ?></span><?php if($endDate) { ?><span class="end-date"> - <?= $endDate ?></span><?php } ?></div><?php } ?>
                                    </div>
                                    <?php if($description) { ?><div class="description"><?= $description; ?></div><?php } ?>
                                    <a href="<?= $link; ?>" class="cta ff-title">Explore More <span class="icon-arrow far fa-long-arrow-right"></span></a>
                                </div>
                            </div>
                        <?php } wp_reset_postdata(); ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php } ?>
