<?php
$selectedPosts = get_sub_field('events');
$title = get_sub_field('title');
$subtitle = get_sub_field('subtitle');
$postArgs = [
    'post_type' => 'post',
    'numberposts' => 6,
];
$posts = $selectedPosts ?: get_posts($postArgs);
$postCounter = 0;

//todo - add instagram functionality
?>

<section class="custom-flexible-section media-section">
    <div class="media-section__contain contain">
        <div class="title-section">
            <?php if($title) { ?><h2><?= $title; ?></h2><?php } ?>
            <?php if($subtitle) { ?><h3 class="ff-title"><?= $subtitle; ?></h3><?php } ?>
        </div>
        <?php if($posts) {
            $defaultImage = \Blue2\Scruffy\Site::getDefaultImage(); ?>
            <div class="media-grid">
                <?php foreach($posts as $post) {

                    $postThumbnailID = get_post_thumbnail_id($post->ID);
                    $postCounter++;
                    $imageSize = $postCounter == 1 ? 'flexible-featured-media' : 'flexible-standard-media';

                    if($postThumbnailID) {
                        $imageAlt = get_post_meta($postThumbnailID, '_wp_attachment_image_alt', TRUE);
                        $imageDetails = wp_get_attachment_image_src($postThumbnailID, $imageSize);
                        $image = '<img src="' . $imageDetails[0] . '" alt="' . $imageAlt . '" loading="lazy"/>';
                        $imageClass = 'featured-image';
                    } else {
                        $image = $defaultImage;
                        $imageClass = 'default-image';
                    }
                    ?>
                    <div class="grid-item">
                        <a href="<?= get_the_permalink($post->ID); ?>" class="<?= $imageClass; ?>">

                            <?= $image; ?>

                            <div class="grid-info">
                                <div class="date"><?= get_the_date('d F Y', $post->ID); ?></div>
                                <h4 class="title"><?= get_the_title($post->ID); ?></h4>
                            </div>
                        </a>
                    </div>
                <?php } wp_reset_postdata(); ?>
            </div>
        <?php } ?>
    </div>
</section>
