<?php
$films = get_field('films');
?>

<main class="single-film-layout">
    <div class="contain single-film-layout__contain">
        <?php if($films) { ?>
            <div class="single-film-layout__output film-output">
                <?php foreach($films as $film) {
                    $title = $film['title'];
                    $description = $film['description'];
                    $embed = $film['film'];
                    ?>
                    <div class="film-output__item film-item">
                        <?php if($title) { ?><h3><?= $title; ?></h3><?php } ?>
                        <?php if($description) { ?><div class="description"><?= $description; ?></div><?php } ?>
                        <?php if($embed) { ?>
                            <div class="embed-output">
                                <?php
                                preg_match('/src="(.+?)"/', $embed, $matches);
                                $src = $matches[1];
                                $params = [
                                    'controls'  => 1,
                                    'hd'        => 1,
                                    'autohide'  => 1,
                                    'rel' => 0
                                ];
                                $new_src = add_query_arg($params, $src);
                                $embed = str_replace($src, $new_src, $embed);
                                $attributes = 'frameborder="0" loading="lazy"';
                                $embed = str_replace('></iframe>', ' ' . $attributes . '></iframe>', $embed);

                                echo $embed; ?>
                            </div>
                       <?php }  ?>
                    </div>
                <?php } ?>
            </div>
        <?php } ?>
    </div>
    <?php get_template_part('templates/whats-on/single-layouts/associated-artists'); ?>
</main>

