<?php

$queryObject = get_queried_object();

$craftProductCategory = get_term_by( 'slug', 'craft-design', 'product_cat' );
$args = array(
    'taxonomy' => 'product_cat',
    'hide_empty' => false,
    'parent'   => $craftProductCategory->term_id
);
$craftDesignSubCategories = get_terms( $args );

$activeTaxonomy = (is_tax() && $queryObject->slug) ? $queryObject->slug : "" ;
?>

<div class="p-header__filter p-header-filter p-craft-header-filter">
    <div class="p-header-filter_contain contain">
        <div class="filter-wrapper">
            <ul class="ff-title" id="accordion-list">
                <div class="toggle-holder"><span class="accordion-toggle far fa-chevron-down"></span></div>
                <li class="craft-artists <?= $queryObject->slug == 'craft-design' ? 'active order-1' : 'order-2';  ?>"><a href="/artist-type/craft-design/">Artists</a></li>
                <li class="<?= is_product_category() && ($activeTaxonomy == $queryObject->slug) ? 'active order-1' : 'order-2';  ?>"><a href="/product-category/craft-design/">All</a></li>
                <?php
                if($craftDesignSubCategories) {
                    foreach ($craftDesignSubCategories as $subCategory) { ?>
                        <li class="<?= $subCategory->slug; ?> <?= $activeTaxonomy == $subCategory->slug ? 'active order-1' : 'order-2'; ?>">
                            <a href="<?= get_category_link($subCategory->term_id); ?>"><?= $subCategory->name; ?></a>
                        </li>
                    <?php }
                } ?>
            </ul>
        </div>
    </div>
</div>
