<!-- todo - add search functionality -->

<?php
$artists = get_posts(['post_type' => 'artist', 'numberposts' => -1, 'orderby' => 'title', 'order' => 'ASC']);
?>

<div class="search-block">
    <div class="search-block__contain contain">
        <form method="get" class="form-grid" action="" role="search">
            <div class="grid-item">
                <label for="search-curated" class="ff-title">Curated for you:</label>
                <div class="select-wrapper">
                    <select name="search-curated" id="search-curated">
                        <option>I am...</option>
                        <option>More Options</option>
                        <option>I am...</option>
                    </select>
                </div>
            </div>
            <div class="grid-item">
                <label for="search-keyword" class="ff-title">Search by keyword:</label>
                <div class="text-input-wrapper">
                    <input type="text" name="search-keyword" id="search-keyword" placeholder="Search for...">
                </div>
            </div>

            <div class="grid-item">
                <label for="search-price" class="ff-title">Price</label>
                <div class="select-wrapper">
                    <select name="search-price" id="search-price">
                        <option>All</option>
                    </select>
                </div>
            </div>

            <div class="grid-item">
                <label for="search-artist" class="ff-title">Artist</label>
                <div class="select-wrapper">
                    <select name="search-artist" id="search-artist">
                        <option>All</option>
                        <?php if($artists) {
                            foreach($artists as $artist) { ?>
                                <option value="<?= $artist->post_name; ?>"><?= $artist->post_title; ?></option>
                            <?php }
                        } ?>
                    </select>
                </div>
            </div>
            <div class="grid-item">
                <label for="search-medium" class="ff-title">Medium</label>
                <div class="select-wrapper">
                    <select name="search-medium" id="search-medium">
                        <option>All</option>
                    </select>
                </div>
            </div>
            <div class="grid-item">

                <label for="search-subject" class="ff-title">Subject</label>
                <div class="select-wrapper">
                    <select name="search-subject" id="search-subject">
                        <option>All</option>
                    </select>
                </div>
            </div>
            <div class="grid-item text-center">
                <button type="submit" class="gold-button">Search</button>
            </div>

        </form>
    </div>
</div>
