<?php
namespace Blue2\Scruffy;

use Blue2\Scruffy\Controllers\ArtistController;
use Blue2\Scruffy\Controllers\EventController;
use Blue2\Scruffy\Controllers\WhatsOnController;

class Site extends \Blue2\Common\Site
{
    public function __construct()
    {
        parent::__construct();

        add_theme_support('woocommerce');
        add_theme_support('post-thumbnails');
        add_action('after_setup_theme', [$this, 'registerMenus']);
        add_filter('excerpt_more', [$this, 'tidyExcerpt']);

        $this->registerShortCodes();
        $this->registerFilters();
        $this->registerActions();
        $this->setupControllers();
    }

    public function registerMenus()
    {
        register_nav_menus([
            'main_menu' => 'Main Menu',
            'hamburger_menu' => 'Hamburger Menu',
            'footer_menu' => 'Footer Menu'
        ]);
    }

    public function tidyExcerpt()
    {
        return '...';
    }

    private function registerShortCodes()
    {
        // Empty
    }

    private function registerFilters(){
        add_filter('acf/fields/google_map/api', [$this, 'myAcfGoogleMapApi']);
    }

    private function registerActions() {
        add_action('init', [$this, 'registerPostTypes']);
        add_action('init', [$this, 'customImageSizes']);
        add_action('navigation_markup_template', [$this, 'removePaginationHeader']);
    }

    private function setupControllers(){
        new WhatsOnController();
        new ArtistController();
        new EventController();
    }

    public function registerPostTypes()
    {
        Post\Event::registerPostType();
        Post\Artist::registerPostType();
        Post\WhatsOn::registerPostType();
    }

    public function myAcfGoogleMapApi($api)
    {
        $api['key'] = 'AIzaSyDdUGCrXY_C6q_xVXAJUgeRXyNkO4SldDs';
        return $api;
    }

    public function customImageSizes()
    {
        add_image_size('whats-on-archive-large', 760, 570, true);
        add_image_size('whats-on-archive-small', 356, 356, true);
        add_image_size('whats-on-single-full', 1568, 627, false);
        add_image_size('block-slide', 495, 371, true);
        add_image_size('artist-image', 280, 280, true);
        add_image_size('artist-image-large', 355, 355, true);
        add_image_size('featured-event-image', 1029, 772, true);
        add_image_size('small-event-image', 221, 166, true);
        add_image_size('flexible-featured-media', 1029, 1029, true);
        add_image_size('flexible-standard-media', 489, 489, true);
        add_image_size('flexible-split-25', 356, 0, false);
        add_image_size('flexible-split-40', 625, 0, false);
        add_image_size('flexible-split-50', 760, 0, false);
        add_image_size('flexible-split-60', 895, 0, false);
        add_image_size('flexible-split-75', 1164, 0, false);
        add_image_size('flexible-image-block-3', 491, 0, false);
        add_image_size('flexible-image-block-4', 356, 0, false);
        add_image_size('flexible-image-block-6', 221, 0, false);
    }

    public static function getDefaultImage() {
        $path = get_template_directory() . '/dist/images/TSG-main-logo.svg';
        $file = file_get_contents($path);
        // remove xml header
        $file = str_replace(
            '<?xml version="1.0" encoding="UTF-8"?>',
            '',
            $file
        );
        // add class and attributes for accessibility
        return str_replace(
            '<svg',
            '<svg class="l-header__logo" role="img" aria-label="The Scottish Gallery"',
            $file
        );
    }

    public static function getPostImage($id, $size = null){
        $imageSize = $size ?: 'full';
        $defaultImage = self::getDefaultImage();
        $imgID = get_post_thumbnail_id($id);
        if($imgID) {
            $imageAlt = get_post_meta($imgID, '_wp_attachment_image_alt', TRUE);
            $imageDetails = wp_get_attachment_image_src($imgID, $imageSize);
            $image = '<img src="' . $imageDetails[0] . '" alt="' . $imageAlt . '" loading="lazy"/>';
            $imageClass = 'featured-image';
        } else {
            $image = $defaultImage;
            $imageClass = 'default-image';
        }
        return['item' => $image, 'class' => $imageClass];
    }

    function removePaginationHeader($content) {
        $content = preg_replace('#<h2.*?>(.*?)<\/h2>#si', '', $content);
        return $content;
    }

}
