<?php

namespace Blue2\Scruffy\Controllers;

class EventController
{
    public function __construct()
    {
        $this->registerActions();
        $this->registerFilters();
    }

    private function registerActions()
    {
        add_action('pre_get_posts', [$this, 'setEventsPerPage']);
    }

    private function registerFilters()
    {

    }

    public function setEventsPerPage( $query ) {
        if ( !is_admin() && $query->is_main_query() && is_post_type_archive( 'event' ) ) {

            $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
            $postsPerPage = $paged == 1 ? 11 : 12;
            $query->set( 'posts_per_page', $postsPerPage );
            $query->set( 'meta_key', 'date_time' );
            $query->set( 'meta_type', 'DATETIME' );
            $query->set( 'orderby', 'meta_value' );
            $query->set( 'order', 'ASC' );
        }
    }

}
