<?php
$artistTypes = get_terms('artist-type');
?>

<section class="p-header">
    <div class="p-header__title p-header-title">
        <div class="p-heaer-title__contain contain">
            <?php if ( function_exists('yoast_breadcrumb') ) {
                yoast_breadcrumb( '<div class="p-header-title__breadcrumbs ff-title">', '</div>' );
            } ?>
            <h1 class="ff-title"><?php post_type_archive_title(); ?></h1>
        </div>
    </div>
    <div class="p-header__filter p-header-filter">
        <div class="p-header-filter_contain contain">
            <div class="filter-wrapper">
                <ul class="ff-title" id="accordion-list">
                    <div class="toggle-holder"><span class="accordion-toggle far fa-chevron-down"></span></div>
                    <li class="currently-showing <?= !isset($_GET['type']) ? 'active order-1' : 'order-2';  ?>"><a href="/artists/">All</a></li>
                    <?php
                    if($artistTypes) {
                        foreach ($artistTypes as $type) { ?>
                            <li class="<?= $type->slug; ?> <?= isset($_GET['type']) && $_GET['type'] == $type->slug ? 'active order-1' : 'order-2'; ?>">
                                <a href="/artists/?type=<?= $type->slug; ?>"><?= $type->name; ?></a>
                            </li>
                        <?php }
                    } ?>
                </ul>
            </div>
        </div>
    </div>
</section>
<section class="p-archive-artists-output">
    <div class="p-archive-artists-output__contain contain">

        <div class="p-archive-artists-output__mode-switch ff-title">
            <a href="" id="view-by-grid" role="button"><span class="fas fa-th-large"></span>View by grid</a>
            <a href="" id="view-by-list" role="button"><span class="fas fa-list"></span>View by list</a>
        </div>

        <?php
        $artistArgs = [
            'post_type' => 'artist',
            'posts_per_page' => -1,
            'post_status' => 'publish',
        ];

        $artistQuery = new WP_Query($artistArgs);
        $artistData = [];

        if ( $artistQuery->have_posts() ) {
            while ($artistQuery->have_posts()) {
                $artistQuery->the_post();
                $firstLetter = get_the_title()[0];
                $artistData[$firstLetter][] = [
                    'id' => get_the_id(),
                    'title' => get_the_title(),
                    'slug' => get_post_field('post_name', get_post()),
                ];

            } wp_reset_postdata();
        }

        if($artistData) { ?>
            <div class="artist-output">
            <?php foreach($artistData as $key => $data) { ?>
                <div class="artist-output__letter artist-letter">
                    <div class="letter ff-title"><?= $key; ?></div>
                    <ul>
                        <?php foreach($data as $artist) { ?>
                            <li class="artist-letter__item">
                                <a href="<?= get_the_permalink($artist['id']); ?>">
                                    <?= $artist['title']; ?>
                                </a>
                            </li>
                        <?php } ?>
                    </ul>
                </div>
            <?php } ?>
            </div>
        <?php } ?>
    </div>
</section>
