<?php
$eventArgs = [
    'post_type' => 'event',
    'numberposts' => -1,
    'meta_key' => 'date_time',
    'meta_type' => 'DATETIME',
    'orderby' => 'meta_value',
    'order' => 'ASC'
];
$events = new WP_Query($eventArgs);
$eventCounter = 0;
?>

<section class="p-header">
    <div class="p-header__title p-header-title">
        <div class="p-heaer-title__contain contain">
            <?php if ( function_exists('yoast_breadcrumb') ) {
                yoast_breadcrumb( '<div class="p-header-title__breadcrumbs ff-title">', '</div>' );
            } ?>
            <h1 class="ff-title"><?php post_type_archive_title(); ?></h1>
        </div>
    </div>
</section>

<main class="p-archive-events-output">
    <div class="p-archive-events-output__contain contain">
        <?php if ($events->have_posts()) { ?>
            <div class="row row-eq-height">
                <?php while ($events->have_posts()) {
                    $events->the_post();
                    $eventCounter++;
                    echo $eventCounter == 1 || $eventCounter == 2 ? get_template_part('templates/event/content/featured') : get_template_part('templates/event/content/standard');
                } ?>
            </div>
        <?php } else { ?>
            <div class="no-event-results">
                <?= get_template_part('templates/event/content/no-results'); ?>
            </div>
        <?php } wp_reset_postdata(); ?>
    </div>
</main>
