<?php
$exhibitions = get_field('exhibitions');
$defaultImage = \Blue2\Scruffy\Site::getDefaultImage();
?>


<main class="single-exhibition-layout">
    <div class="contain single-exhibition-layout__contain">
        <?php if($exhibitions) { ?>
            <div class="single-exhibition-layout__output exhibition-output">
                <div class="row">
                    <?php foreach($exhibitions as $exhibition) {
                        $whatsOnInfo = \Blue2\Scruffy\Controllers\WhatsOnController::getWhatsOnArchiveInfo($exhibition->ID);
                        if($whatsOnInfo['associated_artists']) {
                            $artistNames = [];
                            foreach ($whatsOnInfo['associated_artists'] as $artist) {
                                array_push($artistNames, $artist->post_title);
                            }
                        }
                        ?>
                        <div class="col-lg-6 col-xl-12 exhibition-output__item">
                            <div class="row">
                                <div class="col-xl-6">
                                    <div class="image-wrap <?= $whatsOnInfo['archive_image_class']; ?>">
                                        <a href="<?php the_permalink(); ?>">
                                            <?= $whatsOnInfo['archive_image']; ?>
                                        </a>
                                    </div>
                                </div>
                                <div class="col-xl-6">
                                    <div class="content-wrap">
                                        <?php if($whatsOnInfo['associated_artists']) { ?><div class="artists ff-title"><?= implode(', ', $artistNames) ?></div><?php } ?>
                                        <h2><?php the_title(); ?></h2>
                                        <div class="date"><?= $whatsOnInfo['start_date'] . ' - ' . $whatsOnInfo['end_date']; ?></div>
                                        <div class="archive-description"><?= $whatsOnInfo['archive_description']; ?></div>
                                        <a href="<?php the_permalink(); ?>" class="cta ff-title">Explore More <span class="icon-arrow far fa-long-arrow-right"></span></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        <?php } ?>
    </div>
    <?php get_template_part('templates/whats-on/single-layouts/associated-artists'); ?>
</main>

