<?php
namespace Blue2\Scruffy;

use Blue2\Scruffy\Controllers\ArtistController;
use Blue2\Scruffy\Controllers\WhatsOnController;

class Site extends \Blue2\Common\Site
{
    public function __construct()
    {
        parent::__construct();

        add_theme_support('woocommerce');
        add_theme_support('post-thumbnails');
        add_action('after_setup_theme', [$this, 'registerMenus']);
        add_filter('excerpt_more', [$this, 'tidyExcerpt']);

        $this->registerShortCodes();
        $this->registerFilters();
        $this->registerActions();
        $this->setupControllers();
    }

    public function registerMenus()
    {
        register_nav_menus([
            'main_menu' => 'Main Menu',
            'hamburger_menu' => 'Hamburger Menu',
            'footer_menu' => 'Footer Menu'
        ]);
    }

    public function tidyExcerpt()
    {
        return '...';
    }

    private function registerShortCodes()
    {
        // Empty
    }

    private function registerFilters(){
        // Empty
    }

    private function registerActions() {
        add_action('init', [$this, 'registerPostTypes']);
        add_action('init', [$this, 'customImageSizes']);
    }

    private function setupControllers(){
        new WhatsOnController();
        new ArtistController();
    }

    public function registerPostTypes()
    {
        Post\Event::registerPostType();
        Post\Artist::registerPostType();
        Post\WhatsOn::registerPostType();
    }

    public function customImageSizes()
    {
        add_image_size('whats-on-archive-large', 776, 582, true);
        add_image_size('whats-on-archive-small', 364, 364, true);
        add_image_size('whats-on-single-full', 1600, 640, false);
        add_image_size('block-slide', 505, 379, true);
        add_image_size('artist-image', 280, 280, true);
    }

    public static function getDefaultImage() {
        $path = get_template_directory() . '/dist/images/TSG-main-logo.svg';
        $file = file_get_contents($path);
        // remove xml header
        $file = str_replace(
            '<?xml version="1.0" encoding="UTF-8"?>',
            '',
            $file
        );
        // add class and attributes for accessibility
        return str_replace(
            '<svg',
            '<svg class="l-header__logo" role="img" aria-label="The Scottish Gallery"',
            $file
        );
    }

    public static function getPostImage($id, $size = null){
        $imageSize = $size ?: 'full';
        $defaultImage = self::getDefaultImage();
        $imgID = get_post_thumbnail_id($id);
        if($imgID) {
            $imageAlt = get_post_meta($imgID, '_wp_attachment_image_alt', TRUE);
            $imageDetails = wp_get_attachment_image_src($imgID, $imageSize);
            $image = '<img src="' . $imageDetails[0] . '" alt="' . $imageAlt . '" loading="lazy"/>';
            $imageClass = 'featured-image';
        } else {
            $image = $defaultImage;
            $imageClass = 'default-image';
        }
        return['item' => $image, 'class' => $imageClass];
    }


}
