<?php

$slides = get_sub_field('slides');
$defaultImage = \Blue2\Scruffy\Site::getDefaultImage();


if($slides) { ?>
    <section class="custom-flexible-section full-width-slider">
        <div class="full-width-slider__contain contain">
            <div class="full-width-slide__output slider-output">
                <div class="swiper-container slider-output__container">
                    <div class="swiper-wrapper slider-output__wrapper">
                        <?php foreach($slides as $slide) { ?>
                            <div class="slider-output__slide <?= $slide['slide_type']; ?>">
                                <?php if($slide['slide_type'] == 'exhibition-selection') {
                                    $whatsOnInfo = \Blue2\Scruffy\Controllers\WhatsOnController::getWhatsOnArchiveInfo($slide['exhibition_selector'], 'full');
                                    if($whatsOnInfo['associated_artists']) {
                                        $artistNames = [];
                                        foreach ($whatsOnInfo['associated_artists'] as $artist) {
                                            array_push($artistNames, $artist->post_title);
                                        }
                                    }
                                    $mainTitle = implode(', ', $artistNames) ?: "";
                                    $subtitle = $whatsOnInfo['title'];
                                    $imageClass = $whatsOnInfo['archive_image_class'];
                                    $image = $whatsOnInfo['archive_image'];
                                    $startDate = $whatsOnInfo['start_date'];
                                    $endDate = $whatsOnInfo['end_date'];
                                    $description = $whatsOnInfo['archive_description'];
                                } else {
                                    $mainTitle = $slide['slide_main_title'];
                                    $subtitle = $slide['slide_subtitle'];
                                    $startDate = $slide['slide_start_date'];
                                    $endDate = $slide['slide_end_date'];
                                    $description = $slide['slide_description'];

                                    // todo - add image check
                                    $image = $defaultImage;
                                    $imageClass = 'default-image';

                                } ?>

                                <div class="image-wrapper <?= $imageClass; ?>">
                                    <?= $image; ?>
                                    <div class="swiper-pagination"></div>
                                </div>
                                <div class="content-wrapper">
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <?php if($mainTitle) { ?><h2><?= $mainTitle; ?></h2><?php } ?>
                                        </div>
                                        <div class="col-lg-6">

                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php } ?>
