<?php

namespace Blue2\Scruffy\Controllers;

class WhatsOnController
{
    public function __construct()
    {
        $this->registerActions();
        $this->registerFilters();
    }

    private function registerActions()
    {
        add_action('init', [$this, 'addWhatsOnSingleEndpoints']);
    }

    private function registerFilters()
    {
        add_filter( 'request', [$this, 'whatsOnSingleFilterRequest']);
    }

    function whatsOnSingleFilterRequest( $vars )
    {
        if( isset( $vars['films'] ) ) $vars['films'] = true;
        if( isset( $vars['artworks'] ) ) $vars['artworks'] = true;
        if( isset( $vars['viewing-rooms'] ) ) $vars['viewing_rooms'] = true;
        if( isset( $vars['events'] ) ) $vars['events'] = true;
        return $vars;
    }

    public function addWhatsOnSingleEndpoints()
    {
        add_rewrite_endpoint('films', EP_PERMALINK | EP_PAGES);
        add_rewrite_endpoint('artworks', EP_PERMALINK | EP_PAGES);
        add_rewrite_endpoint('viewing-rooms', EP_PERMALINK | EP_PAGES);
        add_rewrite_endpoint('events', EP_PERMALINK | EP_PAGES);
    }

    public static function getWhatsOnArchiveInfo($id = null, $size = null) {

        $whatsOnId = $id ?: get_the_id();

        $defaultImage = \Blue2\Scruffy\Site::getDefaultImage();

        $title = get_the_title($whatsOnId);
        $startDate = get_field('start_date', $whatsOnId);
        $endDate = get_field('end_date', $whatsOnId);
        $archiveDescription = get_field('archive_description', $whatsOnId);
        $associatedArtists = get_field('associated_artists', $whatsOnId);
        $archiveImage = get_field('archive_image', $whatsOnId);

        if(!$size) {
            $imageSize = isset($_GET['type']) && $_GET['type'] == 'past' ? 'whats-on-archive-small' : 'whats-on-archive-large';
        } else {
            $imageSize = 'whats-on-single-full';
        }

        if($archiveImage){
            $imgID = $archiveImage;
            $imageAlt = get_post_meta($imgID, '_wp_attachment_image_alt', TRUE);
            $imageDetails = wp_get_attachment_image_src($imgID, $imageSize);
            $image = '<img src="' . $imageDetails[0] . '" alt="'. $imageAlt .'" loading="lazy"/>';
            $imageClass = 'archive-image';
        } elseif(!$archiveImage && get_the_post_thumbnail_url($whatsOnId)){
            $imgID = get_post_thumbnail_id($whatsOnId);
            $imageAlt = get_post_meta($imgID, '_wp_attachment_image_alt', TRUE);
            $imageDetails = wp_get_attachment_image_src($imgID, $imageSize);
            $image = '<img src="' . $imageDetails[0] . '" alt="'. $imageAlt .'" loading="lazy"/>';
            $imageClass = 'featured-image';
        } else{
            $image = $defaultImage;
            $imageClass = 'default-image';
        }

        $startDateOutput = date("d F Y", strtotime($startDate));
        $endDateOutput = date("d F Y", strtotime($endDate));


        $info = [
            'title' => $title,
            'start_date' => $startDateOutput,
            'end_date' => $endDateOutput,
            'archive_description' => $archiveDescription,
            'associated_artists' => $associatedArtists,
            'archive_image' => $image,
            'archive_image_class' => $imageClass,
        ];
        return $info;
    }

    public static function getFeaturedArtistFilm($field, $id = null) {
        $embedName = $field;
        $artistID = $id ?: get_the_id();

        $embed = get_field($embedName, $artistID);

        preg_match('/src="(.+?)"/', $embed, $matches);
        $src = $matches[1];

        $params = [
            'controls'  => 1,
            'hd'        => 1,
            'autohide'  => 1,
            'rel' => 0
        ];
        $new_src = add_query_arg($params, $src);
        $embed = str_replace($src, $new_src, $embed);

        $attributes = 'frameborder="0" loading="lazy"';
        $embed = str_replace('></iframe>', ' ' . $attributes . '></iframe>', $embed);

        echo $embed;
    }
}
