<?php
$openingTimes = get_field('opening_times', 'option');
$fullAddress = get_field('full_address', 'option');
$registeredAsText = get_field('registered_as_text', 'option');
$socials = get_field('social_media_channels', 'option');
$phone = get_field('contact_phone_number', 'option');
$fax = get_field('contact_fax_number', 'option');
$email = get_field('contact_email_address', 'option');
?>

<?php get_template_part('templates/parts/newsletter') ?>


<footer class="l-footer">

        <div class="l-footer__contain contain">

            <hr/>

            <div class="top-row row">
                <div class="col-md-6 col-lg-4 l-footer__building l-footer-building">
                    <div class="l-footer-building__logo-wrapper">
                        <?php
                        $path = get_template_directory() . '/dist/images/building-logo.svg';
                        $file = file_get_contents($path);
                        // remove xml header
                        $file = str_replace(
                            '<?xml version="1.0" encoding="UTF-8"?>',
                            '',
                            $file
                        );
                        // add class and attributes for accessibility
                        echo str_replace(
                            '<svg',
                            '<svg class="l-footer-building__logo" role="img" aria-label="The Scottish Gallery Building"',
                            $file
                        );
                        ?>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4 l-footer__information l-footer-info ff-main">
                    <div class="l-footer-info__logo">
                        <?php
                        $path = get_template_directory() . '/dist/images/TSG-Aitken-logo.svg';
                        $file = file_get_contents($path);
                        // remove xml header
                        $file = str_replace(
                            '<?xml version="1.0" encoding="UTF-8"?>',
                            '',
                            $file
                        );
                        // add class and attributes for accessibility
                        echo str_replace(
                            '<svg',
                            '<svg class="l-footer-info__logo" role="img" aria-label="The Scottish Gallery Logo"',
                            $file
                        );
                        ?>
                    </div>
                    <?php
                    if($openingTimes) { ?>
                        <div class="l-footer-info__opening-times">
                            <h3>Opening Times</h3>
                            <?= $openingTimes; ?>
                        </div>
                    <?php }
                    if($fullAddress) { ?>
                        <div class="l-footer-info__full-address">
                            <?= $fullAddress; ?>
                        </div>
                    <?php } ?>

                    <?php if($phone || $fax || $email) { ?>
                        <div class="l-footer-info__links">
                            <?php if($phone) { ?><div>T: <a href="tel:<?= $phone ?>"><?= $phone; ?></a></div><?php } ?>
                            <?php if($fax) { ?><div>F: <a href="fax:<?= $fax; ?>"><?= $fax; ?></a></div><?php } ?>
                            <?php if($email) { ?><div>E: <a href="mailto:<?= $email; ?>"><?= $email; ?></a></div><?php } ?>
                        </div>
                    <?php } ?>

                    <?php if($socials) { ?>
                        <div class="l-footer-info__socials">
                            <ul>
                                <?php foreach($socials as $social) { ?>
                                    <li><a href="<?= $social['full_url']; ?>" target="_blank"><span class="fab <?= $social['platform'] ?>"></span></a></li>
                                <?php } ?>
                            </ul>
                        </div>
                    <?php } ?>
                </div>
                <div class="col-lg-4 l-footer__map">
                    <img src="<?= get_template_directory_uri() . '/dist/images/footer-map.jpg'; ?>" alt="Scottish Gallery Map" loading="lazy">
                </div>
            </div>
            <div class="bottom-row row">
                <div class="order-lg-2 col-lg-4 l-footer__navigation l-footer-nav ff-title">
                    <?php
                    if (has_nav_menu( 'footer_menu' )) {
                        wp_nav_menu(['theme_location' => 'footer_menu', 'menu_class' => 'l-footer-nav__menu']);
                    }
                    ?>
                </div>
                <div class="order-lg-1 col-sm-6 col-lg-4 l-footer__registered">
                    <?php if($registeredAsText) { ?>
                        <?= $registeredAsText; ?>
                    <?php } ?>
                </div>
                <div class="order-lg-3 col-sm-6 col-lg-4 l-footer__credit">Website by <?= do_shortcode('[blue2_logo type="dark"]'); ?></div>
            </div>
        </div>
</footer>
