<?php
$whatsOnInfo = \Blue2\Scruffy\Controllers\WhatsOnController::getWhatsOnArchiveInfo();

if($whatsOnInfo['associated_artists'] || is_singular('artist')) {
    $artists = is_singular('artist') ? [get_queried_object()] : $whatsOnInfo['associated_artists']; ?>
    <section class="about-the-artist">
        <div class="about-the-artist__contain contain">
            <?php foreach($artists as $artist) {

                $imgID = get_post_thumbnail_id($artist->ID);
                $imageAlt = get_post_meta($imgID, '_wp_attachment_image_alt', TRUE);
                $imageDetails = wp_get_attachment_image_src($imgID, 'artist-image');

                $introduction = get_field('artist_introduction', $artist->ID);
                $description = get_field('artist_description', $artist->ID);
                $film = get_field('featured_artist_film', $artist->ID);

                ?>
                <div class="about-the-artist__wrapper artist-wrapper">
                    <div class="artist-wrapper__title">
                        <h2 class="ff-title"><?= $artist->post_title; ?></h2>
                        <h3>Meet the artist</h3>
                    </div>
                    <div class="artist-wrapper__grid artist-grid">
                        <?php if($imgID) { ?><div class="artist-grid__image"><img src="<?= $imageDetails[0]; ?>" alt="<?= $imageAlt; ?>" loading="lazy"></div><?php } ?>
                        <div class="artist-grid__description">
                            <?php if($introduction) { ?><div class="introduction"><?= $introduction ?></div><?php } ?>
                            <?php if($description) { ?><div class="full"><?= $description ?></div><?php } ?>
                        </div>
                        <div class="artist-grid__films">
                            <?php if($film) { ?>
                                <div class="frame-holder">
                                    <?php \Blue2\Scruffy\Controllers\WhatsOnController::getFeaturedArtistFilm('featured_artist_film', $artist->ID); ?>
                                </div>
                            <?php } ?>
                            <!-- todo - add link + conditional logic -->
                            <a href="" class="gold-button">View all films</a>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
    </section>
<?php } ?>
