<?php

$postThumb = get_the_post_thumbnail_url(null, 'full'); ?>

<section class="article-single custom-article-single" style="background-image:url('<?= get_template_directory_uri() . '/dist/images/background/pilgrims-bg.png'; ?>')">
    <div class="container">

        <div class="row">
            <div class="offset-lg-2 col-lg-8">
                <?php if ( function_exists('yoast_breadcrumb') ) { ?>
                    <div class="post-breadcrumbs">
                        <?php yoast_breadcrumb( '<p id="breadcrumbs">','</p>' ); ?>
                    </div>
                <?php } ?>
            </div>
        </div>



        <div class="article-header-section">
            <div class="row">
                <div class="offset-lg-2 col-lg-8">
                    <h1><?= the_title(); ?></h1>
                    <p><?= get_the_excerpt(); ?></p>
                    <?php
                    $categories = get_the_category();
                    $output = '';
                    if ( ! empty( $categories ) ) { ?>
                        <div class="category-listing">
                            <?php echo '<span class="categories-title">Category:</span>'; ?>
                            <ul class="article-category-list">
                                <?php foreach( $categories as $category ) {
                                    $output .= '<li><a href="' . esc_url( get_category_link( $category->term_id ) ) . '" alt="' . esc_attr( sprintf( __( 'View all posts in %s', 'textdomain' ), $category->name ) ) . '">' . esc_html( $category->name ) . '</a></li>';
                                }
                                echo trim($output); ?>
                            </ul>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>

    <div class="article-content-section">
        <?php if(get_field('sections')) { ?>
            <?php Blue2\Scruffy\Utils::flexibleLoop('sections'); ?>
        <?php } else { ?>
        <div class="container">
            <div class="row">
                <div class="offset-lg-2 col-lg-8">
                    <img src="<?= $postThumb ?>"/>
                    <?php the_content(); ?>
                </div>
            </div>
        </div>
    </div>
    <?php } ?>

    <?php
    $next_post = get_next_post();
    if( ! empty($next_post) ) { ?>
        <div class="align-items-center article-bottom-button">
            <a class="btn btn-primary" href="<?php echo get_permalink( $next_post->ID ); ?>"><span>Next Article</span></a>
        </div>
        <?php
    } ?>
    <div class="align-items-center article-bottom-socials">
        <p class="share-this">Share This Page: </p>
        <?= do_shortcode('[addtoany]'); ?>
    </div>

    </div>

</section>
