<?php

use Blue2\Scruffy\Controllers\PostController;

?>
    <div id="content" class="site-content blog-content">
        <div class="container">
            <?php if ( function_exists('yoast_breadcrumb') ) { ?>
                <div class="blog-breadcrumbs">
                    <?php yoast_breadcrumb( '<p><p id="breadcrumbs">','</p></p>' ); ?>
                </div>
            <?php } ?>

            <div class="article-title">
                <h1>The <span>Pilgrim's</span> Blog</h1>
            </div>

            <div class="row row-eq-height content-area">
                <?php while ( have_posts() ) : the_post();
                    $postThumb = get_the_post_thumbnail_url(null, 'cards'); ?>
                    <div class="col-md-6 col-lg-4 post-block-col">
                        <div class="post-block-item">
                            <a href="<?= get_the_permalink(); ?>">
                                <img src="<?=$postThumb; ?>"/>
                            </a>
                            <div class="news-title">
                                <?php
                                $path = get_template_directory() . '/dist/images/decorations/pilgrim-logo.svg';
                                $file = file_get_contents($path);
                                $file = str_replace(
                                    '<?xml version="1.0" encoding="UTF-8"?>',
                                    '',
                                    $file
                                );
                                echo str_replace(
                                    '<svg',
                                    '<svg class="pilgrim-logo" role="img"',
                                    $file
                                );
                                ?>
                                <h3 class="text-center"><a href="<?= get_the_permalink(); ?>"><?= get_the_title(); ?>  </a></h3>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>
        </div>
    </div>

    <div class="custom-pagination">
        <?php the_posts_pagination([
            'mid_size' => 1,
            'prev_text' => __('&#8592;', 'textdomain'),
            'next_text' => __('&#8594;', 'textdomain'),
            'before_page_number' => '<span class="meta-nav screen-reader-text">' . __('', '') . ' </span>',
        ]); ?>
    </div>

<?php


