<?php

namespace Blue2\Scruffy\Controllers;

class WoocommerceController
{
    public function __construct()
    {
        //remove our woocommerce actions
        remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0);
        remove_action( 'woocommerce_sidebar', 'woocommerce_get_sidebar', 10 );

        //seperate the categories from product loop on shop page
        //remove_filter( 'woocommerce_product_loop_start', 'woocommerce_maybe_show_product_subcategories' );

        //output our categopries before the loop
        add_action( 'woocommerce_before_shop_loop', [$this, 'pilgrims_show_product_subcategories'], 40 );

        add_action( 'woocommerce_before_shop_loop_item_title', [$this, 'add_on_hover_shop_loop_image'] ) ;

        add_filter( 'woocommerce_product_description_tab_title', [$this, 'pilgrims_rename_description_product_tab_label'] );
        add_filter( 'woocommerce_product_reviews_tab_title', [$this, 'pilgrims_rename_reviews_product_tab_label'] );

        add_theme_support('woocommerce');
        add_theme_support( 'wc-product-gallery-zoom' );
        add_theme_support( 'wc-product-gallery-lightbox' );
        add_theme_support( 'wc-product-gallery-slider' );

        add_filter( 'woocommerce_add_to_cart_fragments', 'pilgrims_cart_count_fragments', 10, 1 );
    }

    public function pilgrims_show_product_subcategories() {
        $categories = get_terms('product_cat');
        if($categories && is_shop()) {
            echo '<div class="custom-shop-categories">';
            echo '<div class="category-grid">';
            foreach ($categories as $category) {
                $attachment = get_term_meta( $category->term_id, 'thumbnail_id', true );
                $term_img = wp_get_attachment_url(  $attachment );
                ?>
                <div class="grid-item">
                    <a href="<?= get_category_link($category->term_id); ?>">
                        <div class="image-wrapper">
                            <img src="<?= $term_img; ?>" alt="<?= $category->name; ?>">
                        </div>
                        <div class="content-wrapper">
                            <h3><?= $category->name; ?> <span class="count">(<?= $category->count; ?>)</span></h3>
                        </div>
                    </a>
                </div>
            <?php }
            echo '</div>';
            echo '</div>';
        }
    }

    function add_on_hover_shop_loop_image() {
        global $product;
        $hover_image = get_field( "product_hover_image", $product->get_id() );
        $size = 'product-card';

        if ( $hover_image ) {
            echo wp_get_attachment_image( $hover_image, $size );
        }
    }

    function pilgrims_rename_description_product_tab_label() {
        return 'Product Description' .  '<div><p class="checkbox"></p></div>';
    }

    function pilgrims_rename_reviews_product_tab_label() {
        return 'Reviews' .  '<div><p class="checkbox"></p></div>';
    }

    public function pilgrims_cart_count_fragments( $fragments ) {
        $fragments['li.cart-count'] = '<li class="cart-count"><p class="cart-link--count">' . WC()->cart->get_cart_contents_count() . '</p></li>';

        return $fragments;
    }
}
