<?php

$links = get_sub_field('links');
$primaryAssetType = get_sub_field('primary_asset_type');
$secondaryAssetType = get_sub_field('primary_asset_type');
?>

<div class="triple-block">
    <div class="container-fluid">
        <div class="grid">
            <div class="grid-item grid-item-1 asset-col">
                <?php if($primaryAssetType == 'image') {
                    $image = get_sub_field('primary_image'); ?>
                    <img src="<?= $image['url']; ?>">
                <?php } else {
                    $video = get_sub_field('primary_video');
                    ?>
                    <video autoplay="autoplay" muted loop controls>
                        <source src="<?= $video['url']; ?>" type="video/mp4">
                    </video>
                <?php } ?>
            </div>
            <div class="grid-item grid-item-2 text-center">
                <div class="triple-center-block">
                    <h1><?php the_sub_field('title'); ?></h1>
                    <div class="description"><?php the_sub_field('content'); ?></div>
                    <?php if($links) { ?>
                        <ul>
                            <?php foreach($links as $link) { ?>

                                <li>
                                    <?php
                                    $path = get_template_directory() . '/dist/images/decorations/text-decoration.svg';
                                    $file = file_get_contents($path);
                                    $file = str_replace(
                                        '<?xml version="1.0" encoding="UTF-8"?>',
                                        '',
                                        $file
                                    );
                                    echo str_replace(
                                        '<svg',
                                        '<svg class="decoration-left-svg" role="img"',
                                        $file
                                    );
                                    ?>
                                    <a href="<?= $link['link']['url']; ?>"><?= $link['link']['title']; ?></a>
                                    <?php
                                    $path = get_template_directory() . '/dist/images/decorations/text-decoration.svg';
                                    $file = file_get_contents($path);
                                    $file = str_replace(
                                        '<?xml version="1.0" encoding="UTF-8"?>',
                                        '',
                                        $file
                                    );
                                    echo str_replace(
                                        '<svg',
                                        '<svg class="decoration-right-svg" role="img"',
                                        $file
                                    );
                                    ?>
                                </li>

                            <?php } ?>
                        </ul>
                    <?php } ?>
                </div>
            </div>
            <div class="grid-item grid-item-3 asset-col">
                <?php if($secondaryAssetType == 'image') {
                    $image = get_sub_field('secondary_image'); ?>
                    <img src="<?= $image['url']; ?>">
                <?php } else {
                    $video = get_sub_field('secondary_video');
                    ?>
                    <video autoplay="autoplay" muted loop controls>
                        <source src="<?= $video['url']; ?>" type="video/mp4">
                    </video>
                <?php } ?>
            </div>
        </div>
    </div>
</div>
