<?php

use Blue2\Scruffy\Controllers\PostController;

?>
    <div id="content" class="article-archive" style="background-image:url('<?= get_template_directory_uri() . '/dist/images/background/pilgrims-bg.png'; ?>')">
        <div class="container">
            <?php if ( function_exists('yoast_breadcrumb') ) { ?>
                <div class="post-breadcrumbs">
                    <?php yoast_breadcrumb( '<p id="breadcrumbs">','</p>' ); ?>
                </div>
            <?php } ?>

            <div class="article-title">
                <h1>Latest News</h1>
            </div>


            <div class="news-wrapper">

                <div class="row">
                    <div class="col-lg-8">

                        <?php

                        $defaultImage = get_field('drink_aware_popup_logo', 'option');
                        ?>

                        <?php while ( have_posts() ) : the_post();

                        $imageClass = get_the_post_thumbnail_url() ? 'featured' : 'default';
                        $image = get_the_post_thumbnail_url() ?: $defaultImage['url'];

                        ?>
                            <div class="article-item">
                                <div class="row h-100 row-eq-height no-gutters">
                                    <div class="col-lg-6">
                                        <div class="image-wrapper <?= $imageClass; ?>">
                                            <img src="<?= $image; ?>">
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="content-wrapper">
                                            <h3><?php the_title(); ?></h3>
                                            <div class="content"><?php the_excerpt(); ?></div>
                                            <div class="cta">
                                                <a href="<?php the_permalink(); ?>">
                                                    View Article
                                                    <?php
                                                    $path = get_template_directory() . '/dist/images/decorations/text-decoration.svg';
                                                    $file = file_get_contents($path);
                                                    $file = str_replace(
                                                        '<?xml version="1.0" encoding="UTF-8"?>',
                                                        '',
                                                        $file
                                                    );
                                                    echo str_replace(
                                                        '<svg',
                                                        '<svg class="decoration-right-svg" role="img"',
                                                        $file
                                                    );
                                                    ?>
                                                </a>
                                            </div>

                                        </div>
                                    </div>

                                </div>
                            </div>

                        <?php endwhile; ?>

                        <div class="custom-pagination">
                            <?php the_posts_pagination([
                                'mid_size' => 1,
                                'prev_text' => __('&#8592;', 'textdomain'),
                                'next_text' => __('&#8594;', 'textdomain'),
                                'before_page_number' => '<span class="meta-nav screen-reader-text">' . __('', '') . ' </span>',
                            ]); ?>
                        </div>
                    </div>
                    <div class="col-lg-4 sidebar-col">
                        <aside class="sidebar">
                            <h3>Find By Category:</h3>
                            <?php
                            $categories = get_categories();
                            $cat = [];

                            foreach ( $categories as $category ) {
                                $cat_query = null;
                                $args = array (
                                    'post_type' => 'article',
                                    'taxonomy-name' => $category->slug
                                );

                                $cat_query = new WP_Query( $args );

                                if ( $cat_query->have_posts() ) {
                                    $cat[$category->name] = get_category_link( $category->term_id );
                                }
                            }

                            if(!empty($cat)) {
                                echo '<ul>';

                                foreach($cat as $c => $link) {
                                    echo '<li><a href="' . $link . '">' . $c . '</a></li>';
                                }

                                echo '</ul>';
                            }
                            ?>

                            <?php $newsSidebars = get_field('single_news_sidebar', 'option');
                            if($newsSidebars) { ?>
                                <div class="news-sidebar-links">
                                    <?php foreach($newsSidebars as $newsSidebar) {
                                        $link = $newsSidebar['link'];
                                        $image = $newsSidebar['image'];
                                        ?>
                                        <div class="sidebar-block">
                                            <?php if($link) { ?><a href="<?= $link['url'] ?>"><?php } ?>
                                                <div class="image-wrapper">
                                                    <img src="<?= $image; ?>" alt="<?= $link['title']; ?>">
                                                </div>
                                                <div class="content-wrapper">
                                                    <?php
                                                    $path = get_template_directory() . '/dist/images/decorations/text-decoration.svg';
                                                    $file = file_get_contents($path);
                                                    $file = str_replace(
                                                        '<?xml version="1.0" encoding="UTF-8"?>',
                                                        '',
                                                        $file
                                                    );
                                                    echo str_replace(
                                                        '<svg',
                                                        '<svg class="decoration-left-svg" role="img"',
                                                        $file
                                                    );
                                                    ?>
                                                    <h3><?= $link['title']; ?></h3>
                                                    <?php
                                                    $path = get_template_directory() . '/dist/images/decorations/text-decoration.svg';
                                                    $file = file_get_contents($path);
                                                    $file = str_replace(
                                                        '<?xml version="1.0" encoding="UTF-8"?>',
                                                        '',
                                                        $file
                                                    );
                                                    echo str_replace(
                                                        '<svg',
                                                        '<svg class="decoration-right-svg" role="img"',
                                                        $file
                                                    );
                                                    ?>
                                                </div>
                                                <?php if($link) { ?></a><?php } ?>
                                        </div>
                                    <?php } ?>
                                </div>
                            <?php } ?>

                        </aside>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php
