<?php

$postThumb = get_the_post_thumbnail_url(null, 'full'); ?>

<section class="article-single custom-article-single" style="background-image:url('<?= get_template_directory_uri() . '/dist/images/background/pilgrims-bg.png'; ?>')">
    <div class="container">

        <?php if ( function_exists('yoast_breadcrumb') ) { ?>
            <div class="post-breadcrumbs">
                <?php yoast_breadcrumb( '</p><p id="breadcrumbs">','</p><p>' ); ?>
            </div>
        <?php } ?>

        <div class="row">
            <div class="col-lg-8">
                <div class="article-header-section">
                    <h1><?= the_title(); ?></h1>
                    <p><?= get_the_excerpt(); ?></p>
                    <?php
                    $categories = get_the_category();
                    $output = '';
                    if ( ! empty( $categories ) ) { ?>
                        <div class="category-listing">
                            <?php echo '<span class="categories-title">Category:</span>'; ?>
                            <ul class="article-category-list">
                                <?php foreach( $categories as $category ) {
                                    $output .= '<li><a href="' . esc_url( get_category_link( $category->term_id ) ) . '" alt="' . esc_attr( sprintf( __( 'View all posts in %s', 'textdomain' ), $category->name ) ) . '">' . esc_html( $category->name ) . '</a></li>';
                                }
                                echo trim($output); ?>
                            </ul>
                        </div>
                    <?php } ?>
                </div>
                <div class="article-content-section">
                    <img src="<?= $postThumb ?>"/>
                    <?= the_content();

                    $next_post = get_next_post();
                    if( ! empty($next_post) ) {
                        ?>
                        <div class="col-md-12 align-items-center article-bottom-button">
                            <a class="btn btn-primary" href="<?php echo get_permalink( $next_post->ID ); ?>"><span>Next Article</span></a>
                        </div>
                        <?php
                    } ?>

                    <div class="col-md-12 align-items-center article-bottom-socials">
                        <p class="share-this">Share This Page: </p>
                        <?= do_shortcode('[addtoany]'); ?>
                    </div>
                </div>

            </div>
            <div class="col-lg-4 sidebar-col">
                <div class="sidebar">

                    <div class="share-sidebar-holder">
                        <p class="share-this">Share This Page: </p>
                        <?= do_shortcode('[addtoany]'); ?>
                        <?php if( ! empty($next_post) ) { ?>
                            <div class="next-article">
                                <a class="btn btn-primary" href="<?php echo get_permalink( $next_post->ID ); ?>">Next Article</a>
                            </div>
                        <?php } ?>

                    </div>

                    <?php $newsSidebars = get_field('single_news_sidebar', 'option');
                    if($newsSidebars) { ?>
                        <div class="news-sidebar-links">
                            <?php foreach($newsSidebars as $newsSidebar) {
                                $link = $newsSidebar['link'];
                                $image = $newsSidebar['image'];
                                ?>
                                <div class="sidebar-block">
                                    <?php if($link) { ?><a href="<?= $link['url'] ?>"><?php } ?>
                                        <div class="image-wrapper">
                                            <img src="<?= $image; ?>" alt="<?= $link['title']; ?>">
                                        </div>
                                        <div class="content-wrapper">
                                            <?php
                                            $path = get_template_directory() . '/dist/images/decorations/text-decoration.svg';
                                            $file = file_get_contents($path);
                                            $file = str_replace(
                                                '<?xml version="1.0" encoding="UTF-8"?>',
                                                '',
                                                $file
                                            );
                                            echo str_replace(
                                                '<svg',
                                                '<svg class="decoration-left-svg" role="img"',
                                                $file
                                            );
                                            ?>
                                            <h3><?= $link['title']; ?></h3>
                                            <?php
                                            $path = get_template_directory() . '/dist/images/decorations/text-decoration.svg';
                                            $file = file_get_contents($path);
                                            $file = str_replace(
                                                '<?xml version="1.0" encoding="UTF-8"?>',
                                                '',
                                                $file
                                            );
                                            echo str_replace(
                                                '<svg',
                                                '<svg class="decoration-right-svg" role="img"',
                                                $file
                                            );
                                            ?>
                                        </div>
                                    <?php if($link) { ?></a><?php } ?>
                                </div>
                            <?php } ?>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
</section>
