<?php

$postThumb = get_the_post_thumbnail_url(null, 'full'); ?>

<section class="article-single">
  <?php if ( function_exists('yoast_breadcrumb') ) { ?>
    <div class="container-fluid post-breadcrumbs">
      <?php yoast_breadcrumb( '</p><p id="breadcrumbs">','</p><p>' ); ?>
    </div>
  <?php } ?>

  <div class="container-fluid">
    <div class="post-header col-md-12">
      <div class="col-md-12">
        <h1><?= the_title(); ?></h1>

        <p><?= get_the_excerpt(); ?></p>

        <?php
          $categories = get_the_category();
          $separator = ' ';
          $output = '';

          if ( ! empty( $categories ) ) { 
            echo '<span class="categories-title">Category:</span>&nbsp;&nbsp;';

            foreach( $categories as $category ) {
              $output .= '<a href="' . esc_url( get_category_link( $category->term_id ) ) . '" alt="' . esc_attr( sprintf( __( 'View all posts in %s', 'textdomain' ), $category->name ) ) . '">' . esc_html( $category->name ) . '</a>' . $separator;
            }

            echo trim( $output, $separator );
          }
        ?>
      </div>
    </div>
    <div class="article-content col-md-12">
      <div class="row">
        <div class="col-md-8 news-left">
            <img src="<?= $postThumb ?>"/>
            <?= the_content(); 
            
            $next_post = get_next_post();
            if( ! empty($next_post) ) {
	          ?>
              <div class="col-md-12 align-items-center article-bottom-button">
                <a class="btn btn-primary" href="<?php echo get_permalink( $next_post->ID ); ?>"><span>Next Article</span></a>
              </div>
	          <?php
            } ?>

            <div class="col-md-12 align-items-center article-bottom-socials">
              <p>Share This Page: </p>
              <?= do_shortcode('[addtoany]'); ?>
            </div>

      </div>
      <div class="col-md-4 news-right">
        <div class="container-fluid">
          <div class="row">

            <?php if( ! empty($next_post) ) {
	          ?>
              <div class="col-md-12">
                <div class="row">
                    <div class="col-md-6">
                      <p>Share This Page: </p>
                      <?= do_shortcode('[addtoany]'); ?>
                    </div>
                    <div class="col-md-6">
                      <a class="btn btn-primary" href="<?php echo get_permalink( $next_post->ID ); ?>"><span>Next Article</span></a>
                    </div>
                </div>
              </div>
	          <?php
            } else { ?>
              <div class="col-md-12">
                <p>Share This Page: </p>
                <?= do_shortcode('[addtoany]'); ?>
              </div>
            <?php }
            
            if( have_rows('single_news_sidebar', 'options') ):
                while( have_rows('single_news_sidebar', 'options') ) : the_row();
                    $image = get_sub_field('image');
                    $title = get_sub_field('title'); ?>
                
                    <div class="col-md-12">
                      <img class="text-center" src="<?= $image; ?>" alt="" width="165" height="165" class="alignnone size-full wp-image-1461" />
                      <p class="text-center"><?= $title; ?></p>
                    </div>
                <?php endwhile;
            endif; ?>
          </div>
        </div>
      </div>
      </div>
    </div>
  </div>
</section>

<?php


Blue2\Scruffy\Utils::flexibleLoop('sections'); 