<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

$url =  "https://{$_SERVER['HTTP_HOST']}{$_SERVER['REQUEST_URI']}";
$escaped_url = htmlspecialchars( $url, ENT_QUOTES, 'UTF-8' );

?>

<?php
/**
 * woocommerce_before_single_product hook.
 *
 * @hooked wc_print_notices - 10
 */
do_action( 'woocommerce_before_single_product' );

if ( post_password_required() ) {
    echo get_the_password_form();
    return;
} ?>

<div id="product-<?php the_ID(); ?>" <?php post_class(); ?> style="background-image: url();">
    <?php
    /**
     * woocommerce_before_single_product_summary hook.
     *
     * @hooked woocommerce_show_product_sale_flash - 10
     * @hooked woocommerce_show_product_images - 20
     */
    do_action( 'woocommerce_before_single_product_summary' );
    ?>

    <div class="summary entry-summary">
        <div class="col-xs-12 social-container">
            <p>Share This Page:</p>
            <ul class="social-links">
                <li>
                    <a href="https://www.facebook.com/sharer/sharer.php?u=<?=$escaped_url;?>" target="_blank">
                        <i class="fab fa-facebook"></i>
                    </a>
                </li>
                <li>
                    <a href="https://twitter.com/intent/tweet?text=<?=$escaped_url;?>" target="_blank">
                        <i class="fab fa-twitter"></i>
                    </a>
                </li>
                <li>
                    <a data-pin-do="buttonPin" data-pin-custom="true" href="https://www.pinterest.com/pin/create/button/?url=<?=$escaped_url;?>">
                        <i class="fab fa-pinterest"></i>
                    </a>

                </li>
            </ul>                
        </div>

        <?php
        /**
         * woocommerce_single_product_summary hook.
         *
         * @hooked woocommerce_template_single_title - 5
         * @hooked woocommerce_template_single_rating - 10
         * @hooked woocommerce_template_single_price - 10
         * @hooked woocommerce_template_single_excerpt - 20
         * @hooked woocommerce_template_single_add_to_cart - 30
         * @hooked woocommerce_template_single_meta - 40
         * @hooked woocommerce_template_single_sharing - 50
         * @hooked WC_Structured_Data::generate_product_data() - 60
         */
        do_action( 'woocommerce_single_product_summary' );
        ?>

        <?php if( have_rows('product_awards')) { ?>
            <div class="award-logos">
                <?php while (have_rows('product_awards')) {
                    the_row();
                    $image = get_sub_field('award_logo');
                    $link = get_sub_field('award_link');
                    ?>
                    <div class="award-item">
                        <?php if($link) { ?><a href="<?= $link['url']; ?>"><?php } ?>
                            <img src="<?= $image['url']; ?>">
                        <?php if($link) { ?></a><?php } ?>
                    </div>
                <?php } ?>
            </div>
        <?php } ?>
    </div><!-- .summary -->

    <?php
    /**
     * woocommerce_after_single_product_summary hook.
     *
     * @hooked woocommerce_output_product_data_tabs - 10
     * @hooked woocommerce_upsell_display - 15
     * @hooked woocommerce_output_related_products - 20
     */
    do_action( 'woocommerce_after_single_product_summary' );
    ?>

</div><!-- #product-<?php the_ID(); ?> -->

<?php do_action( 'woocommerce_after_single_product' );

if (have_rows('sections')) {
    while (have_rows('sections')) {
        the_row();
        get_template_part('templates/sections/' . get_row_layout());
    }
}
?>
