<?php
$postThumb = get_the_post_thumbnail_url(null, 'full');
?>

<section class="post-single">
  <?php if ( function_exists('yoast_breadcrumb') ) { ?>
    <div class="container-fluid post-breadcrumbs">
      <?php yoast_breadcrumb( '</p><p id="breadcrumbs">','</p><p>' ); ?>
    </div>
  <?php } ?>

  <div class="container-fluid">
    <div class="post-header col-md-12">
      <div class="col-md-8">
        <h1><?= the_title(); ?></h1>

        <p><?= get_the_excerpt(); ?></p>

        <?php
        $categories = get_the_category();
        $separator = ' ';
        $output = '';

        if ( ! empty( $categories ) ) { 
          echo '<span class="categories-title">Category:</span>&nbsp;&nbsp;';

          foreach( $categories as $category ) {
            $output .= '<a href="' . esc_url( get_category_link( $category->term_id ) ) . '" alt="' . esc_attr( sprintf( __( 'View all posts in %s', 'textdomain' ), $category->name ) ) . '">' . esc_html( $category->name ) . '</a>' . $separator;
          }

          echo trim( $output, $separator );
        }
        ?>

      </div>
      <div class="col-md-4">
        <p>Share This Page: </p>
        <?= do_shortcode('[addtoany]'); ?>
      </div>
    </div>
    <div class="post-content col-md-12">
      <img src="<?= $postThumb ?>"/>
      <?= the_content(); ?>
    </div>
  </div>
</section>

<?php Blue2\Scruffy\Utils::flexibleLoop('sections'); 

