<?php
$drinksCount = get_sub_field('number_of_drinks');
$z_index = get_sub_field('z_index');
$z_index = $z_index + 5; // Boost z index of this section as we want it to be in front of the fixed product layer by default.
?>
<section class="signature-drinks" style="transform: translateZ(<?= $z_index; ?>px); z-index:<?= $z_index; ?>;">
    <h2>Signature Drinks</h2>
    <div class="signature-drinks__container">
        <div class="row flex-lg-row flex-wrap">
            <?php

            if (!$drinksCount) {
                $drinksCount = 2;
            }
            $showExcerpts = get_sub_field('show_excerpts');
            $showViewAll = get_sub_field('view_all_button');

            $args = [
                'posts_per_page' => $drinksCount,
                'offset' => 0,
                'post_type' => 'recipe',
                'orderby' => 'post_date',
                'order' => 'DESC',
                'post_status' => 'publish',
            ];
            $signatureDrinks = new \WP_Query($args);

            if ($signatureDrinks->have_posts()) { ?>

                <?php while ($signatureDrinks->have_posts()) {
                    $signatureDrinks->the_post();

                    $text = strip_shortcodes(get_the_content());
                    $text = apply_filters('the_content', $text);
                    $text = str_replace(']]>', ']]&gt;', $text);

                    $excerpt_length = apply_filters('excerpt_length', 35);
                    $excerpt_more = apply_filters('excerpt_more', ' ' . '[&hellip;]');
                    $excerpt = wp_trim_words($text, $excerpt_length);

                    $linkBtn = get_field('link-button', get_the_ID());
                    $bundleBtn = get_field('buy_bundle_button', get_the_ID());
                    $hoverClass = '';
                    if ($linkBtn || $bundleBtn) {
                        $hoverClass = ' signature-drinks__drink--hover';
                    }
                    $showExcerptsClass = '';
                    if ($showExcerpts == true) {
                        $showExcerptsClass = ' signature-drinks__drink--excerpts';
                    }
                    ?>
                    <div class='signature-drinks__drink<?= $hoverClass . $showExcerptsClass; ?> col-lg'>
                        <div class="post-item align-self-stretch">
                            <div class="signature-drinks__img">
                                <?php
                                $postThumb = get_the_post_thumbnail(get_the_ID(), 'large', ['class' => 'img-fluid']);
                                echo $postThumb;
                                ?>
                            </div>
                            <div class="signature-drinks__content">
                                <h3><?= get_the_title(get_the_ID()); ?></h3>
                                <?php
                                if ($showExcerpts == true) {
                                    ?>
                                    <p><?= $excerpt; ?></p>
                                    <?php
                                }
                                ?>
                            </div>
                            <?php
                            if ($linkBtn || $bundleBtn) {
                                ?>
                                <div class="signature-drinks__buttons">
                                    <?php
                                    if ($linkBtn) {
                                        $linkBtnTitle = $linkBtn['title'];
                                        if (!$linkBtnTitle) {
                                            $linkBtnTitle = 'Read More';
                                        }
                                        echo "<a class='btn btn-primary' href='" . $linkBtn['url'] . "'><span>" . $linkBtnTitle . "</span></a>";
                                    }


                                    if ($linkBtn && $bundleBtn) {
                                        echo '<span> OR </span>';
                                    }


                                    if ($bundleBtn) {
                                        $bundleBtnTitle = $bundleBtn['title'];
                                        if (!$bundleBtnTitle) {
                                            $bundleBtnTitle = 'Buy Bundle';
                                        }
                                        echo "<a class='btn btn-primary' href='" . $bundleBtn['url'] . "'><span>" . $bundleBtnTitle . "</span></a>";
                                    }
                                    ?>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                <?php } ?>
                <?php
            }
            wp_reset_postdata();
            ?>
        </div>
        <?php
        if ($showViewAll == true) {
            echo "<div class='signature-drinks__view-all'><a class='btn btn-secondary' href='/recipes/'><span>View all recipes</span></a></div>";
        }
        ?>
    </div>
</section>