<?php
$zIndex = get_sub_field('z_index');
$limit = get_sub_field('number_of_stories');

$args = array(
    'posts_per_page' => 3, 
    'offset' => 0,
    'orderby' => 'post_date',
    'order' => 'DESC',
    'post_type' => 'post', /* your post type name */
    'post_status' => 'publish'
);

$recentPosts = new WP_Query($args);

global $post;
if( have_rows('section_background') ) {
    while( have_rows('section_background') ) {
        the_row();
        $bgColor = ' '.get_sub_field('background_color');
        $bgImage = get_sub_field('main_image');
    }
} ?>

<section class="custom-news-block" style="background-image: url(<?= $bgImage['url'];?>); transform: translateZ(<?= $zIndex; ?>px); z-index:<?= $zIndex; ?>;">
    <div class="news-block container-fluid">
        <div class="news-block-inner row">
            <div class="col-md-12">
                <h1><?= get_sub_field('news_heading'); ?></h1>
                <hr/>
            </div>

            <?php if ($recentPosts->have_posts()) :
                while ($recentPosts->have_posts()) : $recentPosts->the_post();
                    $postThumb = get_the_post_thumbnail_url(null, 'full'); ?>
                    <?php echo get_the_post_thumbnail('thumbnail'); ?>
                    <div class="news-block-item col-md-4">
                    <a href="<?= get_the_permalink(); ?>"><img src="<?=$postThumb; ?>" class="news-image"></img></a>
                        <div class="news-title"><a href="<?= get_the_permalink(); ?>"><h3><?= get_the_title(); ?></h3></a></div>
                    </div>
                    <?php
                endwhile;
            endif; 
            
            wp_reset_postdata(); ?>
        </div>
    </div>
</section>