<?php
$logo = get_field('company_logo', 'options')['url'];

// The menu handle from the register_nav_menu statement in functions.php
$theme_location = 'main_menu';
$theme_locations = get_nav_menu_locations();
$menu_obj = get_term($theme_locations[$theme_location], 'nav_menu');
$navCount = $menu_obj->count;
$navCountClass = 'nav-count-' . ($navCount + 1);

$backgroundImage = get_field('banner_image');

?>
<header>

<?php if ( !get_field('turn_off_top_borders', 'options')): ?>
    <div class="page-frame--header">
    </div>
<?php endif; // end of if field_name logic ?>

<div class="header-nav <?= $backgroundImage != null ? 'header-background-content' : ''; ?>" style="background:url('<?= $backgroundImage; ?>'">
    <?php if ( is_front_page() ) : 
        $bannerBottle = get_field('front_page_banner_bottle', 'options'); 
        $homeWording = get_field('front_page_banner_wording', 'options');
        $bannerBaseImage = get_field('front_page_banner_image', 'options');
        
        if($bannerBottle == '') {
            $bannerBottle = get_template_directory_uri() . '/dist/images/desktop-home-bottle.png';
        }

        if($bannerWording == '') {
            $bannerWording = get_template_directory_uri() . '/dist/images/desktop-home-wording.png';
        }

        if($bannerBaseImage == '') {
            $bannerBorder = get_template_directory_uri() . '/dist/images/desktop-home-base.png';
        }
        ?>

        <img class="img-fluid header-big-bottle" src="<?= $bannerBottle; ?>" alt="wireframe-Desktop-wide">
        
        <div class="text-container">
            <img class="img-fluid header-pilgrims-text" src="<?= $bannerWording; ?>" alt="wireframe-Desktop-wide">
        </div>

        <img class="header-border" src="<?= $bannerBorder; ?>" alt="wireframe-Desktop-wide">
    <?php endif ?>

    <div class="flex-row menu-container">
            <div class="basket-container">
                <div class="basket" style="background:url('<?= get_template_directory_uri() . '/dist/images/cart-angle.png' ?>')">
                    <?php 
                    echo '<li class="menu--cart"><a class="cart-link--header" href="' . wc_get_cart_url() . '" title="Basket">Basket' . '</span></a><span class="cart-notification">You have items in your basket. <a class="cart-notification__link" href="' . wc_get_cart_url() . '">View basket</a></span></li>'; 
                    echo '<li class="cart-count"><p class="cart-link--count">' . sprintf(_n('%d ', '%d ', WC()->cart->get_cart_contents_count()), WC()->cart->get_cart_contents_count()) . '<?p></li>'
                    ?>
                </div>
            </div>
        <?php if (has_nav_menu('main_menu')) { ?>
            <div class="nav-container">
                <nav role="navigation" id="nav-main" class="okayNav">
                    <?php wp_nav_menu(['theme_location' => 'main_menu','menu_class' => '']); ?>
                </nav>
            </div>
            <?php
        }
        ?>

        <hr class="header-dashes">
    </div>

    <div class="site-brand">
        <a class="navbar-brand" href="<?= esc_url(home_url('/')); ?>">
            <img class="img-fluid" src="<?= $logo; ?>" alt="<?php bloginfo('name'); ?>"/>
        </a>
        <p class="brand-tagline"><?php bloginfo('description'); ?></p>
        <div class="banner-content">
            <?php
            if (have_rows('banner_content')) {
                while (have_rows('banner_content')) {
                    the_row();
                    if (have_rows('calls_to_action')) { ?>
                        <ul class="cta-btn-row">
                            <?php while (have_rows('calls_to_action')) {
                                the_row();
                                $ctaBtn = get_sub_field('cta_button'); ?>
                                <li><a class="btn btn-primary" href="<?= $ctaBtn['url']; ?>"><span><?= $ctaBtn['title']; ?></span></a></li>
                                <?php
                            } ?>
                        </ul>
                        <?php
                    }
                }
            } ?>
        </div>
        <?php if(is_front_page()) { ?>
        <a href="#" class="scrollNav scroll-prompt">
            <img class="img-fluid" src="<?=get_template_directory_uri();?>/dist/images/mouse-body.svg">
            <span class="sr-only">prompt to scroll</span>
        </a>
        <?php } ?>
    </div>
    <?php if(! is_front_page() && ! is_shop() && ! is_product() ) { ?>
        <div class="page-title-container container">
            <div class="page-title">
                <?php if( is_archive( ) && ! is_product_category() ) : ?>
                    <h2><?= esc_html( post_type_archive_title( '', false ) ); ?></h2>
                <?php elseif( is_single() ) : ?>
                    <h2><?= esc_html( the_title() ); ?></h2>
                <?php elseif( is_product_category() ) : ?>
                    <h2><?= esc_html( single_cat_title() ); ?></h2>
                <?php elseif( is_404() ) : ?>
                    <h2><?= esc_html( 'Page Not Found' ); ?></h2>
                <?php else : ?>
                    <h2><?= esc_html( single_post_title() ); ?></h2>
                <?php endif; ?>
            </div>
        </div>
    <?php } ?>
</div>
</header>
<main id="content">