<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Google Tag Manager -->
    <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
    new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
    j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
    'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
    })(window,document,'script','dataLayer','GTM-WHD5RGN');</script>
    <!-- End Google Tag Manager -->

    <link rel="profile" href="http://gmpg.org/xfn/11">
    <link href="https://fonts.googleapis.com/css?family=Raleway:400,700|Roboto:400,500" rel="stylesheet">
    
    <?php if ( get_field( ' turn_off_top_borders', 'options' ) ): ?>
    <style>
        .page-frame--header::before, .page-frame--header::after {
            background-image:none !important;
        }
    </style>
    <?php endif; // end of if field_name logic ?>
    
    <?php wp_head(); ?>
</head>
<?php
    $pageBg = get_field('page_background_image');
    if(!$pageBg){
        $pageBg = get_field('default_page_background_image','options');
        $class='';
        if(is_product() && get_field('product_background_image')){
            $pageBg = get_field('product_background_image');
            $class = 'alt_bg';
        }
    }
    ?>
    
<body <?php body_class($class); ?> style="background-image: url(<?=$pageBg['url']; ?>);" id="<?php if(is_shop()) { echo 'main-shop-page'; } ?>">
<script>document.body.className += ' fade-out';
    setTimeout(
        function () {
            document.querySelector('body').classList.remove('fade-out');
        }
        , 500
    );
    </script>
    <!-- Google Tag Manager (noscript) -->
    <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-WHD5RGN"
    height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
    <!-- End Google Tag Manager (noscript) -->