<?php
?>

<section class="post-single">
  <?php if ( function_exists('yoast_breadcrumb') ) { ?>
    <div class="container-fluid post-breadcrumbs">
      <?php yoast_breadcrumb( '</p><p id="breadcrumbs">','</p><p>' ); ?>
    </div>
  <?php } ?>

  <div class="container-fluid">
    <div class="post-header col-md-12">
      <div class="col-md-12">
        <h1><?= the_title(); ?></h1>

        <?php
          $categories = get_the_category();
          $separator = ' ';
          $output = '';

          if ( ! empty( $categories ) ) { 
            echo '<span class="categories-title">Category:</span>&nbsp;&nbsp;';

            foreach( $categories as $category ) {
              $output .= '<a href="' . esc_url( get_category_link( $category->term_id ) ) . '" alt="' . esc_attr( sprintf( __( 'View all posts in %s', 'textdomain' ), $category->name ) ) . '">' . esc_html( $category->name ) . '</a>' . $separator;
            }

            echo trim( $output, $separator );
          }
        ?>
      </div>
    </div>
    <div class="post-content col-md-12">
      <div class="col-md-8">
        <?= the_content(); ?>
      </div>
      <div class="col-md-4 news-right">
        <div class="container-fluid">
          <div class="row">
            <div class="col-md-12">
              <p>Share This Page: </p>
              <?= do_shortcode('[addtoany]'); ?>
            </div>

            <div class="col-md-12">
              <img src="/content/uploads/2021/04/sqaure-165px-by-165px-1.png" alt="" width="165" height="165" class="alignnone size-full wp-image-1461" />
              <p>View All Recipes</p>
            </div>

            <div class="col-md-12">
              <img src="/content/uploads/2021/04/sqaure-165px-by-165px-1.png" alt="" width="165" height="165" class="alignnone size-full wp-image-1461" />
              <p>View All Events</p>
            </div>

            <div class="col-md-12">
              <img src="/content/uploads/2021/04/sqaure-165px-by-165px-1.png" alt="" width="165" height="165" class="alignnone size-full wp-image-1461" />
              <p>View Our Blog</p>
            </div>
          </div>
        </div>
      </div>
      
    </div>
  </div>
</section>

<?php Blue2\Scruffy\Utils::flexibleLoop('sections'); 