<?php
$logo = get_field('footer_image', 'options')['url'];
$paymentCards = get_field('payment_cards', 'options');
$paymentProcessLogo = get_field('payment_process_logo', 'options');
$video = get_field('page_background_video');
$popUpLogo = get_field('drink_aware_popup_logo', 'options')['url'];
?>
</main>
<?php if($video) { ?>
<video autoplay="autoplay" muted loop class="background-video">
    <source src="<?= $video['url']; ?>" type="video/mp4">
</video>
<?php } ?>
<section class="da_panel">
    <div class="da_panel__content">
        <div class="frame_el--da">
        </div>
        <div class="frame_el--da">
        </div>
        <div class="da_logo_wrapper col col-sm-10 offset-sm-1 col-md-8 offset-md-2">
            <img class="img-fluid" src="<?= $popUpLogo; ?>" alt="<?php bloginfo('name'); ?>" />
            <p class="lead">DRINK AWARE</p>
        </div>
        <p class="lead"><?php the_field('da_main_text', 'options'); ?></p>
        <a class="btn btn-primary da_btn" href="/"><span>Enter Site</span></a>
        <p><?php the_field('da_secondary_text', 'options'); ?></p>
    </div>
</section>
<?php
    $activatePopup = get_field('activate_popup', 'options');

    if ($activatePopup && is_front_page()) {
?>
    <section class="da_panel_product">
        <div class="da_panel_product__content ">
            <a class="btn btn-primary da_btn_product" href="/"><span>X</span></a>
            <?php
                $popupContent = get_field('popup_content', 'options');
            ?>
            <div class="popup-inner">
                <?= $popupContent ?>
            </div>
        </div>
    </section>
<?php
    }
?>
<section class="footer-quick-access">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-5 quick-left">
                <div class="container">
                    <div class="row">
                        <div class="col-md-4">
                            <?php if (has_nav_menu('quick_left')) {
                               wp_nav_menu(['theme_location' => 'quick_left','menu_class' => '']);
                            }
                            ?>
                        </div>
                        <div class="col-md-4">
                            <?php if (has_nav_menu('quick_middle')) { 
                                wp_nav_menu(['theme_location' => 'quick_middle','menu_class' => '']);
                            }
                            ?>
                        </div>
                        <div class="col-md-4">
                            <?php if (has_nav_menu('quick_right')) {
                                wp_nav_menu(['theme_location' => 'quick_right','menu_class' => '']);
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 quick-middle">
            <?php
            if (have_rows('social_media_channels', 'option')) { ?>
                <ul class="social navigation">
                    <?php
                    while (have_rows('social_media_channels', 'option')) {
                        the_row(); ?>
                        <li><a href="<?php the_sub_field('full_url'); ?>" target="_blank" rel="noopener"><i class="<?php the_sub_field('fa5_icon_class'); ?>"></i></a></li>
                    <?php } ?>
                </ul>
            <?php } ?>
            </div>
            <div class="col-lg-5 quick-right">
                <p>At Pilgrims gin we have lots of exclusive promotions and product launches, read our privacy policy here before signing up and then get all the latest from us.</p>
                <br>      
                <form
                    action=""
                    method="get" id="mc-embedded-subscribe-form" name="mc-embedded-subscribe-form" class="validate"
                    target="_blank" novalidate>
                    <label for="newsletter-signup">
                        Sign up to our newsletter:
                    </label>
                    <div class="form-wrapper">
                        <input type="email" value="" name="EMAIL" class="email" id="mce-EMAIL"
                            placeholder="Please enter your email address..." required>
                        <!-- real people should not fill this in and expect good things - do not remove this or risk form bot signups-->
                        <div style="position: absolute; left: -5000px;" aria-hidden="true"><input type="text"
                                name="b_d1b3516dea2ce7b5f404ef446_c77a838f81" tabindex="-1" value=""></div>
                        <button type="submit" value="Subscribe" name="subscribe" id="mc-embedded-subscribe"
                            class="btn btn-secondary btn-compact"><span>GO</span></button>
                    </div>
                </form>
                <div id="mc-embedded-subscribe-mce-responses">
                </div>
            </div>
        </div>
    </div>
</section>
<footer class="site-footer">
    <div class="container-fluid">
        <div class="row">
                        <div class="sign-up col-md-8 col-lg-5">
                <div class="payment-row row">
                    <div class="col">
                        <img class="img-fluid" src="<?= $paymentCards['url']; ?>"
                            alt="<?= $paymentCards['title']; ?>" />
                    </div>
                    <div class="col col-lg-5">
                        <img class="img-fluid" src="<?= $paymentProcessLogo['url']; ?>"
                            alt="<?= $paymentProcessLogo['title']; ?>" />
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-2 offset-lg-5 text-center">
                <img class="brand footer-logo" src="<?= $logo; ?>" alt="<?php bloginfo('name'); ?>" />
            </div>
        </div>
        <div class="row sub-footer">
            <div class="col-lg-5 col-md-7 text-center">
                <?php if (has_nav_menu('footer_menu')) {
                    wp_nav_menu(['theme_location' => 'footer_menu', 'menu_class' => 'list-inline']);
                } ?>
            </div>
            <div class="copyright col-lg-2 d-none d-lg-block text-center">
                <p>&copy; <?= date("Y"); ?> Copyright - <?php bloginfo('name'); ?></p>
            </div>

            <div class="credit col-lg-5 col-md-5">
                <p><span>Website Powered by </span><?= do_shortcode('[blue2_logo type="light"]'); ?></p>
            </div>

            <div class="copyright col-md-12 d-lg-none text-center">
                <p>&copy; <?= date("Y"); ?> Copyright - <?php bloginfo('name'); ?></p>
            </div>
        </div>
    </div>
    <?php if ( !get_field('turn_off_bottom_borders', 'options')): ?>
        <div class="page-frame--footer">
        </div>
    <?php endif; // end of if field_name logic ?>
    </div>
</footer>
