<?php

namespace Blue2\Scruffy\Controllers;

class PostController
{
    public function __construct()
    {
        add_filter('excerpt_more', [$this ,'new_excerpt_more']);
    }

    public static function the_pilgrims_custom_pagination($args = [], $class = 'pagination') {
        if ($GLOBALS['wp_query']->max_num_pages <= 1) return;
    
        $args = wp_parse_args( $args, [
            'mid_size'           => 2,
            'prev_next'          => false,
            'prev_text'          => __('Older posts', 'textdomain'),
            'next_text'          => __('Newer posts', 'textdomain'),
            'screen_reader_text' => __('Posts navigation', 'textdomain'),
        ]);
    
        $links     = paginate_links($args);
        $next_link = get_next_posts_link($args['next_text']);
        $prev_link = get_previous_posts_link($args['prev_text']);
        $template  = apply_filters( 'the_pilgrims_navigation_markup_template', '
        <nav class="navigation %1$s" role="navigation">
            <h2 class="screen-reader-text">%2$s</h2>
            <div class="nav-links">%3$s<div class="page-numbers-container">%4$s</div>%5$s</div>
        </nav>', $args, $class);
        
        $next_link = str_replace('<a','<a class="next"',$next_link);

        $next_link = str_replace('Next','',$next_link);
        
        $prev_link = str_replace('<a','<a class="previous"',$prev_link);

        $prev_link = str_replace('Previous','',$prev_link);
    
        echo sprintf($template, $class, $args['screen_reader_text'], $prev_link, $links, $next_link);
    }

    public function new_excerpt_more( $more ) {
        return '';
    }
}