<?php
$z_index = get_sub_field('z_index');
$z_index = $z_index + 5; // Boost z index of this section as we want it to be in front of the fixed product layer by default.
?>
<section class="featured featured--products" style="transform: translateZ(<?= $z_index; ?>px); z-index:<?= $z_index; ?>;">
    <div class="featured__container featured__container--products">
        <?php
        $products = get_sub_field('products');
        $productsTotal = ' product-total--' . count($products);

        if (have_rows('products')) {
            while (have_rows('products')) {
                the_row();
                $product = get_sub_field('product');
                if ($product) {
                    ?>
                    <div class="product-container col" style="background-image: url('<?= get_sub_field('background_image'); ?>')">
                        <?php
                        $currency = get_woocommerce_currency_symbol();
                        $price = get_post_meta($product->ID, '_regular_price', true);
                        $cutOutImage = get_field('bottle_cut_out_image', $product->ID);
                        $productSectionLink = get_field('product_section_link', $product->ID);

                        if ($productSectionLink !== "" && $productSectionLink !== NULL) {
                            echo "<a href='" . $productSectionLink . "'>";
                        }
                        ?>
                        <?php if($cutOutImage) { ?>
                            <img src="<?= $cutOutImage['url']; ?>" alt="<?= $cutOutImage['alt']; ?>" class="img-fluid">
                        <?php } else { ?>
                            <?= get_the_post_thumbnail($product->ID, 'large', ['class' => 'alignleft img-fluid']); ?>
                        <?php } ?>
                        <?php
                        if ($productSectionLink !== "" && $productSectionLink !== NULL) {
                            echo "</a>";
                        }
                        ?>
                        <a class="btn btn-secondary" href="<?= get_the_permalink($product->ID);?>"><span>More About</span></a>

                        <button type="button" class="btn btn-secondary productModal"
                                data-contentid="#product-<?= $product->ID; ?>"><span>Quick Buy</span></button>
                        
                        <h5><?= get_the_title($product->ID); ?></h5>
                    </div>
                    <div id="product-<?= $product->ID; ?>" class="product-modal-content">
                        <span class="close-modal">X</span>
                        <div class="product-options">
                            <?php echo do_shortcode('[product_page id="' . $product->ID . '"]'); ?>
                        </div>
                        <div class=" d-none col-md-6 order-2 order-md-1">
                            <h2><?= get_the_title($product->ID); ?></h2>
                        </div>
                        <div class="d-none col-md-6 order-1 order-md-2">
                            <?= get_the_post_thumbnail($product->ID, 'large', ['class' => 'alignleft']); ?>
                        </div>

                    </div>
                <?php }
            }
        } ?>
    </div>
</section>

