<?php

use Blue2\Scruffy\Controllers\PostController;

?>
<div id="content" class="site-content">
    <div class="container-fluid news-articles">
        <div class="content-left-wrap col-md-8">
            <div id="primary" class="content-area">
                <?php while ( have_posts() ) : the_post();
                    $postThumb = get_the_post_thumbnail_url(null, 'full'); ?>
                    <div class="post-block-item col-md-6">
                        <a href="<?= get_the_permalink(); ?>"><img src="<?=$postThumb; ?>"></img></a>
                    </div>
                    <div class="post-block-item col-md-6">
                        <h3><?= get_the_title(); ?></h3>

                        <?= get_the_excerpt(); ?>

                        <a class="view-article-link" href="<?= get_the_permalink(); ?>"><p>View Article</p></a>
                    </div>
                <?php endwhile; ?>
            </div>

            <div class="custom-pagination col-md-12">
                <?php 
                PostController::the_pilgrims_custom_pagination([
                    'mid_size' => 1,
                    'prev_text' => __('Previous', 'textdomain'),
                    'next_text' => __('Next', 'textdomain'),
                    'before_page_number' => '<span class="meta-nav screen-reader-text">' . __('', '') . ' </span>',
                ]);
                ?>
            </div>
        </div>

        <div class="content-right-wrap col-md-4">
            <span>Find By Category</span>
            
            <?php
            $categories = get_categories();
            $cat = [];

            foreach ( $categories as $category ) {
                $cat_query = null;
                $args = array (
                    'post_type' => 'article',
                    'taxonomy-name' => $category->slug
                );

                $cat_query = new WP_Query( $args );

                if ( $cat_query->have_posts() ) {
                    $cat[$category->name] = get_category_link( $category->term_id );
                }
            }
            
            if(!empty($cat)) {
                echo '<ul class="news-categories">';

                foreach($cat as $c => $link) {
                    echo '<li><a href="' . $link . '">' . $c . '</a></li>';
                }

                echo '</ul>';
            }
            ?>
        </div>      
    </div>
</div>

<?php
