<?php

namespace Blue2\Scruffy\Controllers;

class WoocommerceController
{
    public function __construct()
    {
        //remove our woocommerce actions
        remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0);
        remove_action( 'woocommerce_sidebar', 'woocommerce_get_sidebar', 10 );

        //seperate the categories from product loop on shop page
        remove_filter( 'woocommerce_product_loop_start', 'woocommerce_maybe_show_product_subcategories' );

        //output our categopries before the loop
        add_action( 'woocommerce_before_shop_loop', [$this, 'calculon_show_product_subcategories'], 40 );
        
        add_action( 'woocommerce_before_shop_loop_item_title', [$this, 'add_on_hover_shop_loop_image'] ) ; 
        
        add_theme_support('woocommerce');
        add_theme_support( 'wc-product-gallery-zoom' );
        add_theme_support( 'wc-product-gallery-lightbox' );
        add_theme_support( 'wc-product-gallery-slider' );

    }

    public function calculon_show_product_subcategories() {
        $subcategories = woocommerce_maybe_show_product_subcategories();
            if ($subcategories) {
                echo '<div class = "shop-categories">'; 
                echo '<ul class="products columns-3 subcategories">',$subcategories,'</ul>';
                echo '</div>'; 
        }
    }

    function add_on_hover_shop_loop_image() {
        global $product;
        $hover_image = get_field( "product_hover_image", $product->get_id() );
        $size = 'product-card';

        if ( $hover_image ) {
            echo wp_get_attachment_image( $hover_image, $size );
        } 
    }
}