<?php

namespace Blue2\Scruffy;

use Blue2\Scruffy\Controllers\WoocommerceController;

class Site extends \Blue2\Common\Site
{
    public function __construct()
    {
        parent::__construct();

        add_action('after_setup_theme', [$this, 'registerMenus']);
        add_action('init', [$this, 'wooCommerceActions']);

        add_filter('excerpt_more', [$this, 'tidyExcerpt']);
        
        //this adds basket to the menu, lets comment it out as we may need it for some themes
        //add_filter('wp_nav_menu_items', [$this, 'addWCBasketLink'], 10, 2);

        add_filter('woocommerce_dropdown_variation_attribute_options_html', [$this, 'variationRadioButtons'], 20, 2);
        add_filter('pre_get_posts', [$this, 'excludeSingleProducts']);

        add_action('init', [$this, 'customImageSizes']);

        /** woocommerce actions **/
        remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_price', 10);
        remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 20);

        add_action('woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 10);
        add_action('woocommerce_single_product_summary', 'woocommerce_template_single_price', 20);
        
        add_filter('woocommerce_is_purchasable', [$this,'wpblog_specific_product'], 20, 2);
        
        add_action('woocommerce_after_order_notes', [$this, 'customGiftField']);
        add_action('woocommerce_checkout_update_order_meta', [$this, 'saveExtraCheckoutFields'], 5, 1);
        add_action('woocommerce_admin_order_data_after_order_details', [$this, 'displayOrderDataInAdmin']);

        $this->registerShortCodes();
        $this->registerFilters();
        $this->registerActions();
        $this->setupControllers();
    }

    private function registerShortCodes()
    {
        add_shortcode('break', [$this, 'customSectionBreak']);
    }

    private function registerFilters()
    {
        // Empty
        add_filter('woocommerce_package_rates', [$this, 'hide_shipping_when_free_is_available'], 100);
    }

    private function registerActions()
    {
        add_action('init', [$this, 'registerPostTypes']);
    }

    private function setupControllers()
    {
        new WoocommerceController();
    }

    public function registerMenus()
    {
        register_nav_menus([
            'main_menu' => 'Main Menu',
            'footer_menu' => 'Footer Menu',
            'quick_left' => 'Quick Access Left Column',
            'quick_middle' => 'Quick Access Middle Column',
            'quick_right' => 'Quick Access Right Column',
        ]);
    }

    public function wpblog_specific_product($purchaseable_product_wpblog, $product)
    {
        if (get_field('product_coming_soon', wc_get_product($product->get_id())->get_parent_id())[0] == 'Yes') {
            return false;
        } else {
            return $purchaseable_product_wpblog;
        }
    }

    public function customImageSizes()
    {
        add_image_size('banner', '1920', '920', true);
        add_image_size('cards', '600', '400', true);
        add_image_size('product-card', '500', '605', true);
        add_image_size('feature', '625', '885', true);
        add_image_size('square', '165', '165', true);
    }

    public function tidyExcerpt()
    {
        return ' &hellip; <a href="' . get_permalink() . '">Continued</a>';
    }

    public function registerPostTypes()
    {
        Post\Event::registerPostType();
        Post\Recipe::registerPostType();
    }

    public function customSectionBreak()
    {
        $html = '<div class="custom-section-break">';
        $html .= '<hr class="custom-hr" />';
        $html .= '<img src="' . get_template_directory_uri() . '/dist/images/calculon-logo.png' . '" alt="Calculon Theme">';
        $html .= '<hr class="custom-hr" />';
        $html .= '</div>';
        return $html;
    }

    public function wooCommerceActions()
    {
        remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_title', 5);
        add_action('woocommerce_single_product_summary', [$this,'wooCommerceSingleTitle'], 5);
    }

    public function wooCommerceSingleTitle()
    {
        $link = get_field('product_link');
        if ($link) { ?>
            <h1 class="product_title entry-title new-title"><a href="<?= $link; ?>"><?php the_title(); ?></a></h1>
        <?php } else { ?>
            <h1 class="product_title entry-title new-title"><?php the_title(); ?></h1>
        <?php }
    }

    public function addWCBasketLink($items, $args)
    {
        if ($args->theme_location == 'main_menu') {
//             if (WC()->cart->get_cart_contents_count() > 0){
            $items .= '<li class="menu--cart"><a class="cart-link--header" href="' . wc_get_cart_url() . '" title="Basket">Basket  <span class="cart-link--count">' . sprintf(_n('%d ', '%d ', WC()->cart->get_cart_contents_count()), WC()->cart->get_cart_contents_count()) . '</span></a><span class="cart-notification">You have items in your basket. <a class="cart-notification__link" href="' . wc_get_cart_url() . '">View basket</a></span></li>';
//             }
        }
        return $items;
    }

    public function variationRadioButtons($html, $args)
    {
        $args = wp_parse_args(apply_filters('woocommerce_dropdown_variation_attribute_options_args', $args), [
            'options' => false,
            'attribute' => false,
            'product' => false,
            'selected' => false,
            'name' => '',
            'id' => '',
            'class' => '',
            'show_option_none' => __('Choose an option', 'woocommerce'),
        ]);

        if (false === $args['selected'] && $args['attribute'] && $args['product'] instanceof WC_Product) {
            $selected_key = 'attribute_' . sanitize_title($args['attribute']);
            $args['selected'] = isset($_REQUEST[$selected_key]) ? wc_clean(wp_unslash($_REQUEST[$selected_key])) : $args['product']->get_variation_default_attribute($args['attribute']);
        }

        $options = $args['options'];
        $product = $args['product'];
        $attribute = $args['attribute'];
        $name = $args['name'] ? $args['name'] : 'attribute_' . sanitize_title($attribute);
        $id = $args['id'] ? $args['id'] : sanitize_title($attribute);
        $class = $args['class'];
        $show_option_none = (bool)$args['show_option_none'];
        $show_option_none_text = $args['show_option_none'] ? $args['show_option_none'] : __('Choose an option', 'woocommerce');

        if (empty($options) && !empty($product) && !empty($attribute)) {
            $attributes = $product->get_variation_attributes();
            $options = $attributes[$attribute];
        }

        $radios = '<div class="variation-radios">';

        if (!empty($options)) {
            if ($product && taxonomy_exists($attribute)) {
                $terms = wc_get_product_terms($product->get_id(), $attribute, [
                    'fields' => 'all',
                ]);

                foreach ($terms as $term) {
                    if (in_array($term->slug, $options, true)) {
                        $radios .= '<input type="radio"  id="product' .$product->id .'_'. esc_attr($term->slug) . '" name="' . esc_attr($name) . '" value="' . esc_attr($term->slug) . '" ' . checked(sanitize_title($args['selected']), $term->slug, false) . '><label class="btn btn-secondary" for="product' .$product->id .'_' . esc_attr($term->slug) . '">' . esc_html(apply_filters('woocommerce_variation_option_name', $term->name)) . '</label>';
                    }
                }
            } else {
                foreach ($options as $option) {
                    $checked = sanitize_title($args['selected']) === $args['selected'] ? checked($args['selected'], sanitize_title($option), false) : checked($args['selected'], $option, false);
                    $radios .= '<input type="radio" id="product' .$product->id .'_' . sanitize_title($option) . '" name="' . esc_attr($name) . '" value="' . esc_attr($option) . '" id="' . sanitize_title($option) . '" ' . $checked . '><label class="btn btn-secondary" for="product' .$product->id .'_' . sanitize_title($option) . '">' . esc_html(apply_filters('woocommerce_variation_option_name', $option)) . '</label>';
                }
            }
        }

        $radios .= '</div>';
        return $html . $radios;
    }


    public function excludeSingleProducts($q)
    {
        if (!$q->is_main_query()) {
            return;
        }
        if (!$q->is_post_type_archive()) {
            return;
        }
        if (!is_admin() && is_shop()) {
            $q->set('post__not_in', [68]);
        }

        remove_filter('pre_get_posts', 'excludeSingleProducts');
    }

    public function getRecentPosts($count)
    {
        $recentPosts = wp_get_recent_posts([
            'numberposts' => $count, // Number of recent posts thumbnails to display
            'post_status' => 'publish' // Show only the published posts
        ]);
        return $recentPosts;
    }

    public function hide_shipping_when_free_is_available($rates)
    {
        $free = array();
        foreach ($rates as $rate_id => $rate) {
            if ('free_shipping' === $rate->method_id) {
                $free[ $rate_id ] = $rate;
                break;
            }
        }
        return ! empty($free) ? $free : $rates;
    }

    public function customGiftField($checkout)
    {
        woocommerce_form_field('is_gift', array(
            'type'          => 'checkbox',
            'label'         => __('Is this a gift?'),
        ), $checkout->get_value('is_gift'));

        woocommerce_form_field('gift_message', array(
            'type'          => 'textarea',
            'label'         => __('Gift message'),
            'placeholder'   => __('Enter your message'),
        ), $checkout->get_value('gift_message'));
    }
    
    // save the extra field when checkout is processed
    public function saveExtraCheckoutFields($orderId)
    {
        if (isset($_POST['is_gift'])) {
            update_post_meta($orderId, 'is_gift', sanitize_text_field($_POST['is_gift']));
        }

        if (isset($_POST['gift_message'])) {
            update_post_meta($orderId, 'gift_message', sanitize_text_field($_POST['gift_message']));
        }
    }

    // display the extra data in the order admin panel
    public function displayOrderDataInAdmin($order)
    {
        if (get_post_meta($order->get_id(), 'is_gift', true)) { ?>
            <div class="order_data_column">
                <h4><?php _e('Gift Message', 'woocommerce'); ?></h4>
                <?php echo '<p><strong>' . __('Gift Message') . ': </strong>' . get_post_meta($order->get_id(), 'gift_message', true) . '</p>'; ?>
            </div>
        <?php } ?>
    <?php
    }
}
