<?php
$logo = get_field('company_logo', 'options')['url'];

// The menu handle from the register_nav_menu statement in functions.php
$theme_location = 'main_menu';
$theme_locations = get_nav_menu_locations();
$menu_obj = get_term($theme_locations[$theme_location], 'nav_menu');
$navCount = $menu_obj->count;
$navCountClass = 'nav-count-' . ($navCount + 1);

$backgroundImage = get_field('banner_image');
$backgroundImage = wp_get_attachment_image_url($backgroundImage, 'full');

?>
<header>

<?php if ( !get_field('turn_off_top_borders', 'options')): ?>
    <div class="page-frame--header">
    </div>
<?php endif; // end of if field_name logic ?>

<div class="header-nav <?= $backgroundImage != null ? 'header-background-content' : ''; ?>">
    <div class="flex-row menu-container">
            <div class="basket-container">
                <div class="basket">
                    <?php 
                    echo '<li class="menu--cart"><a class="cart-link--header" href="' . wc_get_cart_url() . '" title="Basket">Basket' . '</span></a><span class="cart-notification">You have items in your basket. <a class="cart-notification__link" href="' . wc_get_cart_url() . '">View basket</a></span></li>'; 
                    echo '<li class="cart-count">' . sprintf(_n('%d ', '%d ', WC()->cart->get_cart_contents_count()), WC()->cart->get_cart_contents_count()) . '</li>'
                    ?>
                </div>
            </div>
        <?php
        if (have_rows('social_media_channels', 'option')) { ?>
            <div class="col d-md-none">
                <ul class="social navigation">
                    <?php
                    while (have_rows('social_media_channels', 'option')) {
                        the_row(); ?>
                        <li><a href="<?php the_sub_field('full_url'); ?>" target="_blank" rel="noopener"><i class="<?php the_sub_field('fa5_icon_class'); ?>"></i></a></li>
                    <?php } ?>
                </ul>
            </div>
        <?php }
        if (has_nav_menu('main_menu')) { ?>
            <div class="nav-container">
                <nav role="navigation" id="nav-main" class="okayNav">
                    <?php wp_nav_menu(['theme_location' => 'main_menu','menu_class' => '']); ?>
                </nav>
            </div>
            <?php
        }
        ?>
    </div>

    <div class="site-brand">
        <a class="navbar-brand" href="<?= esc_url(home_url('/')); ?>">
            <img class="img-fluid" src="<?= $logo; ?>" alt="<?php bloginfo('name'); ?>"/>
        </a>
        <p class="brand-tagline"><?php bloginfo('description'); ?></p>
        <div class="banner-content">
            <?php
            $bannerContent = get_field('banner_content');
            if (have_rows('banner_content')) {
                while (have_rows('banner_content')) {
                    the_row();
                    if (have_rows('calls_to_action')) { ?>
                        <ul class="cta-btn-row">
                            <?php while (have_rows('calls_to_action')) {
                                the_row();
                                $ctaBtn = get_sub_field('cta_button'); ?>
                                <li><a class="btn btn-primary" href="<?= $ctaBtn['url']; ?>"><span><?= $ctaBtn['title']; ?></span></a></li>
                                <?php
                            } ?>
                        </ul>
                        <?php
                    }
                }
            }
            ?>
        </div>
        <?php if(is_front_page()) { ?>
        <a href="#" class="scrollNav scroll-prompt">
            <img class="img-fluid" src="<?=get_template_directory_uri();?>/dist/images/mouse-body.svg">
            <span class="sr-only">prompt to scroll</span>
        </a>
        <?php } ?>
    </div>
</div>
<?php     
if (get_field('banner_image')) {
        get_template_part('templates/content-extra-content');
    }
?>
</header>
<main id="content">