<?php
$term = get_the_terms(get_the_id(), 'mode-of-study');
$normalInfoBoxes = get_field('info_boxes') ?: get_sub_field('info_boxes');
$defaultCheckboxes = get_field('default_blocks');
$modeOfStudyCheckboxes = null;
if($term) {
    $checkboxTermSlug = str_replace('-', '_', $term[0]->slug) . '_blocks';
    $modeOfStudyCheckboxes =  get_field($checkboxTermSlug);
}
if($normalInfoBoxes || $defaultCheckboxes || $modeOfStudyCheckboxes) { ?>
    <div class="info-swiper-holder">
        <div class="container">

            <div class="swiper-container info-swiper">
                <div class="custom-swiper-controls">
                    <div class="info-swiper-prev custom-button-prev"><i class="fal fa-long-arrow-left"></i></div>
                    <div class="info-swiper-next custom-button-next"><i class="fal fa-long-arrow-right"></i></div>
                </div>
                <div class="swiper-wrapper" role="feed">
                    <?php while ( have_rows("info_boxes") ) {
                        the_row();
                        $bgSet = get_sub_field('use_parent_subject_background_colour') ? 'use-bg' : 'no-bg'; ?>
                        <article class="swiper-slide">
                            <?php if(get_row_layout() == 'text_block') { ?>
                                <div class="info-item text-block <?= $bgSet; ?>">
                                    <?php the_sub_field('text'); ?>
                                </div>
                            <?php }
                            elseif(get_row_layout() == 'image_block') {
                                $image = get_sub_field('image'); ?>
                                <div class="info-item image-block <?= $bgSet; ?>">
                                    <img src="<?= $image['url'];  ?>">
                                </div>
                            <?php }
                            elseif(get_row_layout() == 'bold_message_block') {
                                $source = get_sub_field('source');
                                $sourceText = get_sub_field('source')['title'] ?: 'Source';
                                ?>
                                <div class="info-item bold-message-block <?= $bgSet; ?>">
                                    <span class="large-text"><?php the_sub_field('large_text'); ?></span> <span class="normal-text"><?php the_sub_field('normal_text'); ?></span>
                                    <?php if($source) { ?><div class="source"><a href="<?= $source['url']; ?>" target="<?= $source['target']; ?>"><?= $sourceText; ?></a></div><?php } ?>
                                </div>
                            <?php } ?>
                        </article>
                    <?php }
                    if(is_singular('course')){
                        get_template_part('templates/sections/swipers/global-info-box-slides/default-blocks');
                        get_template_part('templates/sections/swipers/global-info-box-slides/mode-of-study-blocks');
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
