<?php


namespace Blue2\Scruffy\Controllers;

use WP_Post;

class UniteController
{
    public function __construct()
    {
        set_time_limit(-1);
    }

    public function uniteImport()
    {
        echo "Unit-E Import\n";

        $courseInstances = $this->getAllCurrentCourseCodes();
        $allCourseData = $this->getUniteData("http://195.194.136.164/NescolData/UniteWs.asmx/GetCourseAll");

        $found = 0;
        $notFound = 0;
        //Add missing instances
        foreach ($allCourseData as $ref => $info) {
            if (!array_key_exists($ref, $courseInstances)) {
                //get parent reference
                //if it doesn't exist, create it
                $parts = explode('-', $ref);
                $courseCode = $parts[0];
                $instance = array_pop($parts);

                $args = array(
                    'meta_key'   => 'course_reference',
                    'meta_value' => $courseCode,
                    'meta_compare' => '=',
                    'posts_per_page ' => 1,
                    'post_type' => 'course',
                    'post_status' => 'any'
                );
                $query = new \WP_Query($args);

                if ($query->have_posts()) {
                    while ($query->have_posts()) {
                        $query->the_post();

                        $found++;
                        echo($ref . ' : ' . $courseCode . ": FOUND IN WP DATA\n");

                        $row= ['code' => implode('-', $parts),
                                'instance' => $instance];

                        add_row('course_instances', $row);
                    }
                    wp_reset_postdata();
                } else {
                    $notFound++;
                    echo($ref . ' : ' . $courseCode . ": NOT FOUND IN WP DATA\n");
                }
            }
        }

        echo("$found/$notFound\n");

        $courseInstances = $this->getAllCurrentCourseCodes();

        $i = 1;
        $totalCourseInstances = count($courseInstances);

        foreach ($courseInstances as $reference => $courseInstance) {
            $currentCount = '[' . str_pad($i++, 4, '0', STR_PAD_LEFT) . '/' . $totalCourseInstances . '] ';

            if (array_key_exists($reference, $allCourseData)) {
                if ($courseInstance->instance == null || $courseInstance->instance == $allCourseData[$reference]['INSTANCE']) {
                    echo($currentCount . $reference . " and instance " . $courseInstance->instance . ": MATCHED\n");
                    $this->updateCourseInstance($courseInstance->post_id, $allCourseData[$reference]);
                } else {
                    echo($currentCount . $reference . ": IS FOUND, BUT NOT MATCHING " . $courseInstance->instance . "INSTANCE IN UNIT-E DATA\n");
                }
            } else {
                echo($currentCount . $reference . ": NOT FOUND IN UNIT-E DATA\n");
            }
            flush();
        }
        die;
    }

    public function unitePartTimeImport()
    {
        echo "Unit-E Import\n";

        ini_set('memory_limit', '-1');
        ini_set('max_execution_time', '0');
        ini_set('display_errors', 1);

        $courseInstances = $this->getAllCurrentCourseCodes();
        $allCourseData = $this->getPartTimeUniteData("http://195.194.136.164/NescolData/UniteWs.asmx/GetPartTimeCourseFeed?year=2021");

        $found = 0;
        $notFound = 0;

        $courses = [];

        foreach ($allCourseData as $ref => $info) {
            if (!array_key_exists($ref, $courseInstances)) {
                //get parent reference
                //if it doesn't exist, create it
                $parts = explode('-', $ref);
                $courseCode = $parts[0];
                $instance = array_pop($parts);
                $showStatus = $info['ONLINE'] == 'Y' ? true : false;

                if (!array_key_exists($courseCode, $courses)) {
                    $args = array(
                        'meta_key' => 'course_reference',
                        'meta_value' => $courseCode,
                        'meta_compare' => '=',
                        'posts_per_page ' => 1,
                        'post_type' => 'course',
                        'post_status' => 'any'
                    );
                    $query = new \WP_Query($args);

                    if ($query->have_posts()) {
                        while ($query->have_posts()) {
                            $query->the_post();

                            $courses[$courseCode] = get_the_ID();

                            $found++;
                            echo($ref . ' : ' . $courseCode . ": FOUND IN WP DATA\n");

                            $row = ['code' => implode('-', $parts), 'instance' => $instance, 'show_on_site' => $showStatus];
                            add_row('course_instances', $row);

                        }
                        wp_reset_postdata();
                    } else {
                        $notFound++;
                        echo($ref . ' : ' . $courseCode . ": NOT FOUND IN WP DATA\n");
                    }
                } else {
                    $row = ['code' => implode('-', $parts), 'instance' => $instance, 'show_on_site' => $showStatus];
                    add_row('course_instances', $row, $courses[$courseCode]);
                }
            } else {
               $this->updatePartTimeCourseInstance($courseInstances[$ref]->post_id, $allCourseData[$ref]);
            }
        }
        
        echo("$found/$notFound\n");

        $courseInstances = $this->getAllCurrentCourseCodes();

        $i = 1;
        $totalCourseInstances = count($courseInstances);

        foreach ($courseInstances as $reference => $courseInstance) {
            $currentCount = '[' . str_pad($i++, 4, '0', STR_PAD_LEFT) . '/' . $totalCourseInstances . '] ';

            if (array_key_exists($reference, $allCourseData)) {
                if ($courseInstance->instance == null || $courseInstance->instance == $allCourseData[$reference]['INSTANCE']) {
                    echo($currentCount . $reference . " and instance " . $courseInstance->instance . ": MATCHED\n");
                    $this->updateCourseInstance($courseInstance->post_id, $allCourseData[$reference]);
                } else {
                    echo($currentCount . $reference . ": IS FOUND, BUT NOT MATCHING " . $courseInstance->instance . "INSTANCE IN UNIT-E DATA\n");
                }
            } else {
                echo($currentCount . $reference . ": NOT FOUND IN UNIT-E DATA\n");
            }
            flush();
        }

        die();
    }

    private function getUniteData($url)
    {
        $xml = simplexml_load_file($url);
        $json = json_encode($xml);
        $courses = json_decode($json, true);
        $courses = $courses['getCourseInfoAllResult'];

        $uniteCourses = [];
        foreach ($courses as $course) {
            // unset($course['INSTANCE']);
            unset($course['VARIATION']);
            $uniqueCode = $course['CREF'] . "-" . $course['INSTANCE'];
            $uniteCourses[$uniqueCode] = array_filter($course);
        }

        return $uniteCourses;
    }

    public function getPartTimeUniteData($url)
    {
        $xml = simplexml_load_file($url);
        $json = json_encode($xml);
        $courses = json_decode($json, true);
        $courses = $courses['CourseFeed'];

        $uniteCourses = [];
        foreach ($courses as $course) {
            // unset($course['INSTANCE']);
            unset($course['VARIATION']);
            $uniqueCode = $course['CREF'] . "-" . $course['INSTANCE'];
            $uniteCourses[$uniqueCode] = array_filter($course);
        }

        return $uniteCourses;
    }



    private function uniteDateToString($date)
    {
        if (trim($date) !== '') {
            return date('Y-m-d', $date);
        }

        return null;
    }

    private function uniteTextToBoolean($data)
    {
        return $data === 'Y';
    }

    public function getAllCurrentCourseCodes()
    {
        $query = 'SELECT pm.meta_value AS `code`, pm.post_id, pm2.meta_value AS `instance`, p.ID AS `id`, p.post_status, p.ID
                FROM pex_nescoldev_posts p
                JOIN pex_nescoldev_postmeta pm ON p.ID = pm.post_id AND pm.meta_key LIKE "course_instances_%_code"
                JOIN pex_nescoldev_postmeta pm2 ON p.ID = pm2.post_id AND pm2.meta_key LIKE "course_instances_%_instance" AND
                SUBSTRING(pm2.meta_key, 1, 19) = SUBSTRING(pm.meta_key, 1, 19)
                WHERE post_status = "publish" AND p.post_type=\'course\'
                ORDER BY p.ID';
        global $wpdb;
        $results = $wpdb->get_results($query);

        $instances = [];
        foreach ($results as $result) {
            $instRef = $result->instance ?: 1;
            $uniqueCode = $result->code . '-' . $instRef;
            $instances[$uniqueCode] = $result;
        }

        return $instances;
    }

    private function updateCourseInstance($courseId, $courseData)
    {
        $rows = get_field('course_instances', $courseId);
        foreach ($rows as $key => $row) {
            if ($row['code'] === $courseData['CREF'] && $row['instance'] === $courseData['INSTANCE']) {
                $startDate = $this->uniteDateToString($courseData['START_DATE']);
                if ($startDate !== null) {
                    $row['start_date'] = $startDate;
                }

                $endDate = $this->uniteDateToString($courseData['END_DATE']);
                if ($endDate !== null) {
                    $row['end_date'] = $endDate;
                }

                if (isset($courseData['DAY']) && is_string($courseData['DAY'])) {
                    $day = trim($courseData['DAY']);
                    if ($day !== '') {
                        $row['day'] = $day;
                    }
                }

                if (isset($courseData['TIME']) && is_string($courseData['TIME'])) {
                    $time = trim($courseData['TIME']);
                    if ($time !== '') {
                        $row['time'] = $time;
                    }
                }

                $row['show_on_site'] = !$this->uniteTextToBoolean($courseData['HIDE']);
                $row['online'] = $this->uniteTextToBoolean($courseData['ONLINE']);

                $test = update_row('course_instances', $key+1, $row, $courseId);
            }
        }
    }

    private function updatePartTimeCourseInstance($courseId, $courseData)
    {
        $rows = get_field('course_instances', $courseId);
        foreach ($rows as $key => $row) {

            echo "Row Code: " . $row['code'] . "--------- CourseData (CREF): " . $courseData['CREF'] . "--------- Instances: " . $row['instance'] . "-" . $courseData['INSTANCE'] . "\n";

            if ($row['code'] === $courseData['CREF'] && $row['instance'] === $courseData['INSTANCE']) {

                if($courseData['STARTDATE']) {
                    $startDate = $this->uniteDateToString($courseData['STARTDATE']);
                    if ($startDate !== null) {
                        $row['start_date'] = $startDate;
                    }
                }

                if($courseData['ENDDATE']) {
                    $endDate = $this->uniteDateToString($courseData['ENDDATE']);
                    if ($endDate !== null) {
                        $row['end_date'] = $endDate;
                    }
                }

                if (isset($courseData['DAY']) && is_string($courseData['DAY'])) {
                    $day = trim($courseData['DAY']);
                    if ($day !== '') {
                        $row['day'] = $day;
                    }
                }

                if (isset($courseData['TIME']) && is_string($courseData['TIME'])) {
                    $time = trim($courseData['TIME']);
                    if ($time !== '') {
                        $row['time'] = $time;
                    }
                }

                if (isset($courseData['FEES']) && is_string($courseData['FEES'])) {
                    $fees = trim($courseData['FEES']);
                    if ($fees !== '') {
                        $row['fees'] = number_format($fees, 2);
                    }
                }

                if (isset($courseData['PLACESAVAILABLE']) && is_string($courseData['PLACESAVAILABLE'])) {
                    $places = trim($courseData['PLACESAVAILABLE']);
                    if ($places !== '' || $places == 0) {
                        $row['places_available'] = true;
                    }
                }

                if (isset($courseData['LOCATION']) && is_string($courseData['LOCATION'])) {
                    $location = trim($courseData['LOCATION']);
                    $slugLocation = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', strtolower($location))));
                    $queried_post = get_page_by_path($slugLocation, OBJECT, 'location');

                    if ($location !== '' || $location == 0) {
                        $row['location'] = $queried_post;
                    }
                }

                //$row['show_on_site'] = !$this->uniteTextToBoolean($courseData['HIDE']);
                $row['online'] = $this->uniteTextToBoolean($courseData['ONLINE']);

                $test = update_row('course_instances', $key+1, $row, $courseId);
            }
        }
    }
}
